/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.persistence.json.AppTreeNode;

@Schema(name="AppTreeLayerNode", description="Node referencing a layer.")
public class AppTreeLayerNode
implements Serializable,
AppTreeNode {
    private static final long serialVersionUID = 1L;
    private String id;
    private String objectType;
    private String serviceId;
    private String layerName;
    private String description;
    private Boolean visible = true;

    public AppTreeLayerNode id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="A unique identifier across all tree nodes.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AppTreeLayerNode objectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    @Schema(name="objectType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="objectType")
    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public AppTreeLayerNode serviceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @NotNull
    @Schema(name="serviceId", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="serviceId")
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public AppTreeLayerNode layerName(String layerName) {
        this.layerName = layerName;
        return this;
    }

    @NotNull
    @Schema(name="layerName", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="layerName")
    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public AppTreeLayerNode description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description for this node entered by application admin.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AppTreeLayerNode visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @Schema(name="visible", description="Whether this layer should be shown on the map on startup.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="visible")
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppTreeLayerNode appTreeLayerNode = (AppTreeLayerNode)o;
        return Objects.equals(this.id, appTreeLayerNode.id) && Objects.equals(this.objectType, appTreeLayerNode.objectType) && Objects.equals(this.serviceId, appTreeLayerNode.serviceId) && Objects.equals(this.layerName, appTreeLayerNode.layerName) && Objects.equals(this.description, appTreeLayerNode.description) && Objects.equals(this.visible, appTreeLayerNode.visible);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.objectType, this.serviceId, this.layerName, this.description, this.visible);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppTreeLayerNode {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    objectType: ").append(this.toIndentedString((Object)this.objectType)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString((Object)this.serviceId)).append("\n");
        sb.append("    layerName: ").append(this.toIndentedString((Object)this.layerName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString((Object)this.visible)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

