/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRuleDecision;

@Schema(name="AuthorizationRule", description="A single authorization rule.")
public class AuthorizationRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String groupName;
    @Valid
    private Map<String, AuthorizationRuleDecision> decisions = new HashMap();

    public AuthorizationRule groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @NotNull
    @Schema(name="groupName", description="Name of the group.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="groupName")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public AuthorizationRule decisions(Map<String, AuthorizationRuleDecision> decisions) {
        this.decisions = decisions;
        return this;
    }

    public AuthorizationRule putDecisionsItem(String key, AuthorizationRuleDecision decisionsItem) {
        if (this.decisions == null) {
            this.decisions = new HashMap();
        }
        this.decisions.put(key, decisionsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="decisions", description="A map of access type to decision.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="decisions")
    public Map<String, AuthorizationRuleDecision> getDecisions() {
        return this.decisions;
    }

    public void setDecisions(Map<String, AuthorizationRuleDecision> decisions) {
        this.decisions = decisions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationRule authorizationRule = (AuthorizationRule)o;
        return Objects.equals(this.groupName, authorizationRule.groupName) && Objects.equals(this.decisions, authorizationRule.decisions);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.decisions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationRule {\n");
        sb.append("    groupName: ").append(this.toIndentedString((Object)this.groupName)).append("\n");
        sb.append("    decisions: ").append(this.toIndentedString((Object)this.decisions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

