/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.persistence.json.TMAttributeType;

public class TMAttributeDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String comment;
    private TMAttributeType type;
    private String unknownTypeClassName;
    private Boolean nullable;
    private String description;
    private String defaultValue = null;

    public TMAttributeDescriptor name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TMAttributeDescriptor comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Schema(name="comment", description="Comment from the source, if available (such as database comment) [TODO]", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public TMAttributeDescriptor type(TMAttributeType type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TMAttributeType getType() {
        return this.type;
    }

    public void setType(TMAttributeType type) {
        this.type = type;
    }

    public TMAttributeDescriptor unknownTypeClassName(String unknownTypeClassName) {
        this.unknownTypeClassName = unknownTypeClassName;
        return this;
    }

    @Schema(name="unknownTypeClassName", description="Class name of type (as produced by GeoTools DataStore) which isn't in the type enum list and thus unknown. When the type is 'object' this should contain the full class-name, mostly for debugging purposes so the type may be added to the enum list.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="unknownTypeClassName")
    public String getUnknownTypeClassName() {
        return this.unknownTypeClassName;
    }

    public void setUnknownTypeClassName(String unknownTypeClassName) {
        this.unknownTypeClassName = unknownTypeClassName;
    }

    public TMAttributeDescriptor nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    @Schema(name="nullable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="nullable")
    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public TMAttributeDescriptor description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TMAttributeDescriptor defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Schema(name="defaultValue", description="Default value for this attribute. It can be coerced to the type of the attribute using the `type` field.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="defaultValue")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TMAttributeDescriptor tmAttributeDescriptor = (TMAttributeDescriptor)o;
        return Objects.equals(this.name, tmAttributeDescriptor.name) && Objects.equals(this.comment, tmAttributeDescriptor.comment) && Objects.equals(this.type, tmAttributeDescriptor.type) && Objects.equals(this.unknownTypeClassName, tmAttributeDescriptor.unknownTypeClassName) && Objects.equals(this.nullable, tmAttributeDescriptor.nullable) && Objects.equals(this.description, tmAttributeDescriptor.description) && Objects.equals(this.defaultValue, tmAttributeDescriptor.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comment, this.type, this.unknownTypeClassName, this.nullable, this.description, this.defaultValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TMAttributeDescriptor {\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString((Object)this.comment)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    unknownTypeClassName: ").append(this.toIndentedString((Object)this.unknownTypeClassName)).append("\n");
        sb.append("    nullable: ").append(this.toIndentedString((Object)this.nullable)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString((Object)this.defaultValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

