/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import java.util.HashSet;
import java.util.List;
import nl.b3p.tailormap.api.persistence.Group;
import nl.b3p.tailormap.api.repository.GroupRepository;
import nl.b3p.tailormap.api.repository.OIDCConfigurationRepository;
import nl.b3p.tailormap.api.security.ApiSecurityConfiguration;
import nl.b3p.tailormap.api.security.OIDCRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class ApiSecurityConfiguration {
    @Value(value="${tailormap-api.base-path}")
    private String apiBasePath;
    @Value(value="${tailormap-api.admin.base-path}")
    private String adminApiBasePath;
    @Value(value="${tailormap-api.security.disable-csrf:false}")
    private boolean disableCsrf;

    @Bean
    public CookieCsrfTokenRepository csrfTokenRepository() {
        CookieCsrfTokenRepository csrfTokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
        csrfTokenRepository.setCookiePath("/");
        return csrfTokenRepository;
    }

    @Bean
    public SecurityFilterChain apiFilterChain(HttpSecurity http, CookieCsrfTokenRepository csrfTokenRepository) throws Exception {
        if (this.disableCsrf) {
            http.csrf().disable();
        } else {
            http = (HttpSecurity)http.csrf().csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository).and();
        }
        1 redirectStrategy = new /* Unavailable Anonymous Inner Class!! */;
        2 authenticationSuccessHandler = new /* Unavailable Anonymous Inner Class!! */;
        ((HttpSecurity)((FormLoginConfigurer)http.securityMatchers(matchers -> matchers.requestMatchers(new String[]{this.apiBasePath + "/**"})).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{this.adminApiBasePath + "/**"})).hasAuthority("admin")).formLogin().loginPage(this.apiBasePath + "/unauthorized").loginProcessingUrl(this.apiBasePath + "/login")).and()).oauth2Login(arg_0 -> this.lambda$apiFilterChain$4((RedirectStrategy)redirectStrategy, (AuthenticationSuccessHandler)authenticationSuccessHandler, arg_0)).logout().logoutUrl(this.apiBasePath + "/logout").logoutSuccessHandler((request, response, authentication) -> response.sendError(HttpStatus.OK.value(), "OK"));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public OIDCRepository clientRegistrationRepository(OIDCConfigurationRepository repository) {
        return new OIDCRepository(repository);
    }

    @Bean
    public GrantedAuthoritiesMapper userAuthoritiesMapper(GroupRepository repository) {
        return authorities -> {
            HashSet<SimpleGrantedAuthority> mappedAuthorities = new HashSet<SimpleGrantedAuthority>();
            HashSet wantedGroups = new HashSet();
            try {
                authorities.forEach(authority -> {
                    OidcUserAuthority oidcUserAuthority;
                    OidcIdToken idToken;
                    List roles;
                    mappedAuthorities.add((SimpleGrantedAuthority)authority);
                    if (authority instanceof OidcUserAuthority && (roles = (idToken = (oidcUserAuthority = (OidcUserAuthority)authority).getIdToken()).getClaimAsStringList("roles")) != null) {
                        wantedGroups.addAll(roles);
                    }
                });
                for (String groupName : wantedGroups) {
                    if (repository.findById((Object)groupName).isEmpty()) {
                        Group group = new Group();
                        group.setName(groupName);
                        group.setDescription("<imported from SSO>");
                        repository.save((Object)group);
                    }
                    mappedAuthorities.add(new SimpleGrantedAuthority(groupName));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mappedAuthorities;
        };
    }

    private /* synthetic */ void lambda$apiFilterChain$4(RedirectStrategy redirectStrategy, AuthenticationSuccessHandler authenticationSuccessHandler, OAuth2LoginConfigurer login) {
        login.authorizationEndpoint(endpoint -> endpoint.baseUri(this.apiBasePath + "/oauth2/authorization").authorizationRedirectStrategy(redirectStrategy)).redirectionEndpoint(endpoint -> endpoint.baseUri(this.apiBasePath + "/oauth2/callback")).successHandler(authenticationSuccessHandler);
    }
}

