/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.persistence.json.GeoServiceProtocol;
import nl.b3p.tailormap.api.viewer.model.Service;

@Schema(name="Service", description="A service provides one or more layers used in a viewer")
public class Service
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String title;
    private String url;
    private GeoServiceProtocol protocol;
    private String capabilities = null;
    private ServerTypeEnum serverType = ServerTypeEnum.GENERIC;

    public Service id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Service title(String title) {
        this.title = title;
        return this;
    }

    @NotNull
    @Schema(name="title", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Service url(String url) {
        this.url = url;
        return this;
    }

    @NotNull
    @Schema(name="url", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Service protocol(GeoServiceProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="protocol", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="protocol")
    public GeoServiceProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(GeoServiceProtocol protocol) {
        this.protocol = protocol;
    }

    public Service capabilities(String capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @NotNull
    @Schema(name="capabilities", description="capabilities document of the service - currently only for WMTS", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="capabilities")
    public String getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(String capabilities) {
        this.capabilities = capabilities;
    }

    public Service serverType(ServerTypeEnum serverType) {
        this.serverType = serverType;
        return this;
    }

    @NotNull
    @Schema(name="serverType", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="serverType")
    public ServerTypeEnum getServerType() {
        return this.serverType;
    }

    public void setServerType(ServerTypeEnum serverType) {
        this.serverType = serverType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return Objects.equals(this.id, service.id) && Objects.equals(this.title, service.title) && Objects.equals(this.url, service.url) && Objects.equals(this.protocol, service.protocol) && Objects.equals(this.capabilities, service.capabilities) && Objects.equals(this.serverType, service.serverType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.url, this.protocol, this.capabilities, this.serverType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Service {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString((Object)this.url)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString((Object)this.capabilities)).append("\n");
        sb.append("    serverType: ").append(this.toIndentedString((Object)this.serverType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

