package nl.b3p.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Node referencing a layer.
 */

@Schema(name = "AppTreeLayerNode", description = "Node referencing a layer.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen")
public class AppTreeLayerNode implements Serializable, AppTreeNode {

  private static final long serialVersionUID = 1L;

  private String id;

  private String objectType;

  private String serviceId;

  private String layerName;

  private String description;

  private Boolean visible = true;

  public AppTreeLayerNode id(String id) {
    this.id = id;
    return this;
  }

  /**
   * A unique identifier across all tree nodes.
   * @return id
  */
  
  @Schema(name = "id", description = "A unique identifier across all tree nodes.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public AppTreeLayerNode objectType(String objectType) {
    this.objectType = objectType;
    return this;
  }

  /**
   * Get objectType
   * @return objectType
  */
  
  @Schema(name = "objectType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("objectType")
  public String getObjectType() {
    return objectType;
  }

  public void setObjectType(String objectType) {
    this.objectType = objectType;
  }

  public AppTreeLayerNode serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

  /**
   * Get serviceId
   * @return serviceId
  */
  @NotNull 
  @Schema(name = "serviceId", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("serviceId")
  public String getServiceId() {
    return serviceId;
  }

  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }

  public AppTreeLayerNode layerName(String layerName) {
    this.layerName = layerName;
    return this;
  }

  /**
   * Get layerName
   * @return layerName
  */
  @NotNull 
  @Schema(name = "layerName", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("layerName")
  public String getLayerName() {
    return layerName;
  }

  public void setLayerName(String layerName) {
    this.layerName = layerName;
  }

  public AppTreeLayerNode description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description for this node entered by application admin.
   * @return description
  */
  
  @Schema(name = "description", description = "Description for this node entered by application admin.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AppTreeLayerNode visible(Boolean visible) {
    this.visible = visible;
    return this;
  }

  /**
   * Whether this layer should be shown on the map on startup.
   * @return visible
  */
  
  @Schema(name = "visible", description = "Whether this layer should be shown on the map on startup.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("visible")
  public Boolean getVisible() {
    return visible;
  }

  public void setVisible(Boolean visible) {
    this.visible = visible;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppTreeLayerNode appTreeLayerNode = (AppTreeLayerNode) o;
    return Objects.equals(this.id, appTreeLayerNode.id) &&
        Objects.equals(this.objectType, appTreeLayerNode.objectType) &&
        Objects.equals(this.serviceId, appTreeLayerNode.serviceId) &&
        Objects.equals(this.layerName, appTreeLayerNode.layerName) &&
        Objects.equals(this.description, appTreeLayerNode.description) &&
        Objects.equals(this.visible, appTreeLayerNode.visible);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, objectType, serviceId, layerName, description, visible);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppTreeLayerNode {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    objectType: ").append(toIndentedString(objectType)).append("\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    layerName: ").append(toIndentedString(layerName)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

