package nl.b3p.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * model for describing the style of an application
 */

@Schema(name = "AppStyling", description = "model for describing the style of an application")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen")
public class AppStyling implements Serializable {

  private static final long serialVersionUID = 1L;

  private String primaryColor = null;

  private String logo = null;

  public AppStyling primaryColor(String primaryColor) {
    this.primaryColor = primaryColor;
    return this;
  }

  /**
   * the primary color for an application
   * @return primaryColor
  */
  
  @Schema(name = "primaryColor", description = "the primary color for an application", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("primaryColor")
  public String getPrimaryColor() {
    return primaryColor;
  }

  public void setPrimaryColor(String primaryColor) {
    this.primaryColor = primaryColor;
  }

  public AppStyling logo(String logo) {
    this.logo = logo;
    return this;
  }

  /**
   * application logo
   * @return logo
  */
  
  @Schema(name = "logo", description = "application logo", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("logo")
  public String getLogo() {
    return logo;
  }

  public void setLogo(String logo) {
    this.logo = logo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppStyling appStyling = (AppStyling) o;
    return Objects.equals(this.primaryColor, appStyling.primaryColor) &&
        Objects.equals(this.logo, appStyling.logo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(primaryColor, logo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppStyling {\n");
    sb.append("    primaryColor: ").append(toIndentedString(primaryColor)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

