package nl.b3p.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.tailormap.api.viewer.model.ColumnMetadata;
import nl.b3p.tailormap.api.viewer.model.Feature;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * A -possibly empty- list of features with requested attributes and presentation metadata
 */

@Schema(name = "FeaturesResponse", description = "A -possibly empty- list of features with requested attributes and presentation metadata")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen")
public class FeaturesResponse implements Serializable {

  private static final long serialVersionUID = 1L;

  private Integer total = null;

  private Integer page = null;

  private Integer pageSize = null;

  @Valid
  private List<@Valid Feature> features = new ArrayList<>();

  @Valid
  private List<@Valid ColumnMetadata> columnMetadata = new ArrayList<>();

  public FeaturesResponse total(Integer total) {
    this.total = total;
    return this;
  }

  /**
   *  the total number of available features, can be an estimated value. Can be missing when unknown or irrelevant (eg. featureinfo request) 
   * @return total
  */
  
  @Schema(name = "total", description = " the total number of available features, can be an estimated value. Can be missing when unknown or irrelevant (eg. featureinfo request) ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("total")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public FeaturesResponse page(Integer page) {
    this.page = page;
    return this;
  }

  /**
   * current page, this will allow the client to request the next or previous page by adding or removing 1 or more
   * minimum: 1
   * @return page
  */
  @Min(1) 
  @Schema(name = "page", description = "current page, this will allow the client to request the next or previous page by adding or removing 1 or more", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("page")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  public FeaturesResponse pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * number of features in a page, this will allow calculating the offset (page * pagesize)
   * minimum: 1
   * @return pageSize
  */
  @Min(1) 
  @Schema(name = "pageSize", accessMode = Schema.AccessMode.READ_ONLY, description = "number of features in a page, this will allow calculating the offset (page * pagesize)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pageSize")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public FeaturesResponse features(List<@Valid Feature> features) {
    this.features = features;
    return this;
  }

  public FeaturesResponse addFeaturesItem(Feature featuresItem) {
    if (this.features == null) {
      this.features = new ArrayList<>();
    }
    this.features.add(featuresItem);
    return this;
  }

  /**
   * list of features. When the pagenumber*pagesize exceeds the number of features this list will be empty
   * @return features
  */
  @NotNull @Valid 
  @Schema(name = "features", description = "list of features. When the pagenumber*pagesize exceeds the number of features this list will be empty", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("features")
  public List<@Valid Feature> getFeatures() {
    return features;
  }

  public void setFeatures(List<@Valid Feature> features) {
    this.features = features;
  }

  public FeaturesResponse columnMetadata(List<@Valid ColumnMetadata> columnMetadata) {
    this.columnMetadata = columnMetadata;
    return this;
  }

  public FeaturesResponse addColumnMetadataItem(ColumnMetadata columnMetadataItem) {
    if (this.columnMetadata == null) {
      this.columnMetadata = new ArrayList<>();
    }
    this.columnMetadata.add(columnMetadataItem);
    return this;
  }

  /**
   * presentation metadata
   * @return columnMetadata
  */
  @NotNull @Valid 
  @Schema(name = "columnMetadata", description = "presentation metadata", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("columnMetadata")
  public List<@Valid ColumnMetadata> getColumnMetadata() {
    return columnMetadata;
  }

  public void setColumnMetadata(List<@Valid ColumnMetadata> columnMetadata) {
    this.columnMetadata = columnMetadata;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FeaturesResponse featuresResponse = (FeaturesResponse) o;
    return Objects.equals(this.total, featuresResponse.total) &&
        Objects.equals(this.page, featuresResponse.page) &&
        Objects.equals(this.pageSize, featuresResponse.pageSize) &&
        Objects.equals(this.features, featuresResponse.features) &&
        Objects.equals(this.columnMetadata, featuresResponse.columnMetadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, page, pageSize, features, columnMetadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FeaturesResponse {\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    columnMetadata: ").append(toIndentedString(columnMetadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

