/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

public class AppLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Integer opacity = 100;
    private String attribution = null;
    private String description = null;
    private Boolean editable = null;
    @Valid
    private List<String> hideAttributes;
    @Valid
    private List<String> readOnlyAttributes;

    public AppLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AppLayerSettings opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="opacity", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="opacity")
    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public AppLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public AppLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AppLayerSettings editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    @Schema(name="editable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="editable")
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public AppLayerSettings hideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
        return this;
    }

    public AppLayerSettings addHideAttributesItem(String hideAttributesItem) {
        if (this.hideAttributes == null) {
            this.hideAttributes = new ArrayList();
        }
        this.hideAttributes.add(hideAttributesItem);
        return this;
    }

    @Schema(name="hideAttributes", description="List of attribute names that should be hidden (in addition to attributes already hidden by the feature type settings).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hideAttributes")
    public List<String> getHideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
    }

    public AppLayerSettings readOnlyAttributes(List<String> readOnlyAttributes) {
        this.readOnlyAttributes = readOnlyAttributes;
        return this;
    }

    public AppLayerSettings addReadOnlyAttributesItem(String readOnlyAttributesItem) {
        if (this.readOnlyAttributes == null) {
            this.readOnlyAttributes = new ArrayList();
        }
        this.readOnlyAttributes.add(readOnlyAttributesItem);
        return this;
    }

    @Schema(name="readOnlyAttributes", description="List of feature type attribute names that are not editable (in addition to read only attributes from the feature type settings).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="readOnlyAttributes")
    public List<String> getReadOnlyAttributes() {
        return this.readOnlyAttributes;
    }

    public void setReadOnlyAttributes(List<String> readOnlyAttributes) {
        this.readOnlyAttributes = readOnlyAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppLayerSettings appLayerSettings = (AppLayerSettings)o;
        return Objects.equals(this.title, appLayerSettings.title) && Objects.equals(this.opacity, appLayerSettings.opacity) && Objects.equals(this.attribution, appLayerSettings.attribution) && Objects.equals(this.description, appLayerSettings.description) && Objects.equals(this.editable, appLayerSettings.editable) && Objects.equals(this.hideAttributes, appLayerSettings.hideAttributes) && Objects.equals(this.readOnlyAttributes, appLayerSettings.readOnlyAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.opacity, this.attribution, this.description, this.editable, this.hideAttributes, this.readOnlyAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString((Object)this.opacity)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString((Object)this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString((Object)this.editable)).append("\n");
        sb.append("    hideAttributes: ").append(this.toIndentedString((Object)this.hideAttributes)).append("\n");
        sb.append("    readOnlyAttributes: ").append(this.toIndentedString((Object)this.readOnlyAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

