/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools;

import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.persistence.Application;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.referencing.CRS;

public class TransformationUtil {
    private TransformationUtil() {
    }

    public static MathTransform getTransformationToApplication(@NotNull Application application, @NotNull SimpleFeatureSource simpleFeatureSource) throws FactoryException {
        CoordinateReferenceSystem appCRS;
        MathTransform transform = null;
        CoordinateReferenceSystem dataSourceCRS = ((SimpleFeatureType)simpleFeatureSource.getSchema()).getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)dataSourceCRS, (Object)(appCRS = CRS.decode((String)application.getCrs())))) {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)dataSourceCRS, (CoordinateReferenceSystem)appCRS);
        }
        return transform;
    }

    public static MathTransform getTransformationToDataSource(@NotNull Application application, @NotNull SimpleFeatureSource simpleFeatureSource) throws FactoryException {
        CoordinateReferenceSystem appCRS;
        MathTransform transform = null;
        CoordinateReferenceSystem dataSourceCRS = ((SimpleFeatureType)simpleFeatureSource.getSchema()).getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)dataSourceCRS, (Object)(appCRS = CRS.decode((String)application.getCrs())))) {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)appCRS, (CoordinateReferenceSystem)dataSourceCRS);
        }
        return transform;
    }
}

