/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import nl.b3p.tailormap.api.persistence.Group;
import nl.b3p.tailormap.api.persistence.listener.EntityEventPublisher;
import nl.b3p.tailormap.api.util.TMPasswordDeserializer;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;

@Entity
@Table(name="users")
@EntityListeners(value={EntityEventPublisher.class})
public class User
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @Pattern(regexp="^[a-zA-Z0-9-]+", message="Username must consist of alphanumeric characters or -")
    private @Pattern(regexp="^[a-zA-Z0-9-]+", message="Username must consist of alphanumeric characters or -") String username;
    @Version
    private Long version;
    @NotNull
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JsonDeserialize(using=TMPasswordDeserializer.class)
    @Size(max=68)
    private @NotNull @Size(max=68) String password;
    @Email
    private String email;
    private String name;
    @Column(columnDefinition="text")
    private String notes;
    @Column(columnDefinition="timestamp with time zone")
    private ZonedDateTime validUntil;
    private boolean enabled;
    @Type(type="io.hypersistence.utils.hibernate.type.json.JsonBinaryType")
    @Column(columnDefinition="jsonb")
    private JsonNode additionalProperties;
    @ManyToMany
    @JoinTable(name="user_groups", joinColumns={@JoinColumn(name="username")}, inverseJoinColumns={@JoinColumn(name="group_name")})
    private Set<Group> groups;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public User() {
        this.$$_hibernate_write_enabled(true);
        this.$$_hibernate_write_groups(new HashSet());
    }

    public String getUsername() {
        return this.$$_hibernate_read_username();
    }

    public User setUsername(String username) {
        this.$$_hibernate_write_username(username);
        return this;
    }

    public Long getVersion() {
        return this.$$_hibernate_read_version();
    }

    public User setVersion(Long version) {
        this.$$_hibernate_write_version(version);
        return this;
    }

    public String getPassword() {
        return this.$$_hibernate_read_password();
    }

    public User setPassword(String passwordHash) {
        this.$$_hibernate_write_password(passwordHash);
        return this;
    }

    public String getEmail() {
        return this.$$_hibernate_read_email();
    }

    public User setEmail(String email) {
        this.$$_hibernate_write_email(email);
        return this;
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public User setName(String name) {
        this.$$_hibernate_write_name(name);
        return this;
    }

    public String getNotes() {
        return this.$$_hibernate_read_notes();
    }

    public User setNotes(String notes) {
        this.$$_hibernate_write_notes(notes);
        return this;
    }

    public JsonNode getAdditionalProperties() {
        return this.$$_hibernate_read_additionalProperties();
    }

    public User setAdditionalProperties(JsonNode additionalProperties) {
        this.$$_hibernate_write_additionalProperties(additionalProperties);
        return this;
    }

    public Set<Group> getGroups() {
        return this.$$_hibernate_read_groups();
    }

    public User setGroups(Set<Group> groups) {
        this.$$_hibernate_write_groups(groups);
        return this;
    }

    public Set<String> getGroupNames() {
        return this.$$_hibernate_read_groups().stream().map(Group::getName).collect(Collectors.toSet());
    }

    public ZonedDateTime getValidUntil() {
        return this.$$_hibernate_read_validUntil();
    }

    public User setValidUntil(ZonedDateTime validUntil) {
        this.$$_hibernate_write_validUntil(validUntil);
        return this;
    }

    public boolean isEnabled() {
        return this.$$_hibernate_read_enabled();
    }

    public User setEnabled(boolean enabled) {
        this.$$_hibernate_write_enabled(enabled);
        return this;
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        User user = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                User user = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("groups");
                if (this.groups != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.groups == null || this.groups instanceof PersistentCollection && !((PersistentCollection)this.groups).wasInitialized() || n == this.groups.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                User user = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("groups");
                if (this.groups != null || n == -1) break block1;
                dirtyTracker.add("groups");
                break block0;
            }
            if (this.groups == null || this.groups instanceof PersistentCollection && !((PersistentCollection)this.groups).wasInitialized() || n == this.groups.size()) break block0;
            dirtyTracker.add("groups");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            User user = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("groups")) break block3;
            if (this.groups == null || this.groups instanceof PersistentCollection && !((PersistentCollection)this.groups).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("groups", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("groups", this.groups.size());
            }
        }
    }

    public String $$_hibernate_read_username() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "username", (Object)this.username);
        }
        return this.username;
    }

    public void $$_hibernate_write_username(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "username", (Object)this.username, (Object)string);
            return;
        }
        this.username = string;
    }

    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (Object)l, (Object)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)this.version, (Object)l);
            return;
        }
        this.version = l;
    }

    public String $$_hibernate_read_password() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.password = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "password", (Object)this.password);
        }
        return this.password;
    }

    public void $$_hibernate_write_password(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"password", (Object)string, (Object)this.password)) {
            this.$$_hibernate_trackChange("password");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.password = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "password", (Object)this.password, (Object)string);
            return;
        }
        this.password = string;
    }

    public String $$_hibernate_read_email() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "email", (Object)this.email);
        }
        return this.email;
    }

    public void $$_hibernate_write_email(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"email", (Object)string, (Object)this.email)) {
            this.$$_hibernate_trackChange("email");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "email", (Object)this.email, (Object)string);
            return;
        }
        this.email = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", (Object)this.notes);
        }
        return this.notes;
    }

    public void $$_hibernate_write_notes(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"notes", (Object)string, (Object)this.notes)) {
            this.$$_hibernate_trackChange("notes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "notes", (Object)this.notes, (Object)string);
            return;
        }
        this.notes = string;
    }

    public ZonedDateTime $$_hibernate_read_validUntil() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.validUntil = (ZonedDateTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "validUntil", (Object)this.validUntil);
        }
        return this.validUntil;
    }

    public void $$_hibernate_write_validUntil(ZonedDateTime zonedDateTime) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"validUntil", (Object)zonedDateTime, (Object)this.validUntil)) {
            this.$$_hibernate_trackChange("validUntil");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.validUntil = (ZonedDateTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "validUntil", (Object)this.validUntil, (Object)zonedDateTime);
            return;
        }
        this.validUntil = zonedDateTime;
    }

    public boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "enabled", this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"enabled", (boolean)bl, (boolean)this.enabled)) {
            this.$$_hibernate_trackChange("enabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "enabled", this.enabled, bl);
            return;
        }
        this.enabled = bl;
    }

    public JsonNode $$_hibernate_read_additionalProperties() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.additionalProperties = (JsonNode)this.$$_hibernate_getInterceptor().readObject((Object)this, "additionalProperties", (Object)this.additionalProperties);
        }
        return this.additionalProperties;
    }

    public void $$_hibernate_write_additionalProperties(JsonNode jsonNode) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"additionalProperties", (Object)jsonNode, (Object)this.additionalProperties)) {
            this.$$_hibernate_trackChange("additionalProperties");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.additionalProperties = (JsonNode)this.$$_hibernate_getInterceptor().writeObject((Object)this, "additionalProperties", (Object)this.additionalProperties, (Object)jsonNode);
            return;
        }
        this.additionalProperties = jsonNode;
    }

    public Set $$_hibernate_read_groups() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.groups = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "groups", this.groups);
        }
        return this.groups;
    }

    public void $$_hibernate_write_groups(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.groups = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "groups", this.groups, (Object)set);
            return;
        }
        this.groups = set;
    }
}

