/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.persistence.json.Bounds;
import nl.b3p.tailormap.api.persistence.json.WMSStyle;

@Schema(name="GeoServiceLayer", description="Layer of a service which can be an OGC WMS/WMTS service or from XYZ/ArcGIS REST.")
public class GeoServiceLayer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private Boolean root;
    private String title;
    private Boolean virtual;
    private Double maxScale;
    private Double minScale;
    @Valid
    private Set<String> crs;
    private Bounds latLonBoundingBox;
    @Valid
    private @Valid List<@Valid WMSStyle> styles;
    private Boolean queryable;
    private String abstractText;
    @Valid
    private List<String> children = new ArrayList<String>();

    public GeoServiceLayer id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Unique id assigned by TM, not from the capabilities. Assigned to make a tree with virtual layers. When referring to a non-virtual layer the name should always be used.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GeoServiceLayer name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GeoServiceLayer root(Boolean root) {
        this.root = root;
        return this;
    }

    @NotNull
    @Schema(name="root", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="root")
    public Boolean getRoot() {
        return this.root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    public GeoServiceLayer title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GeoServiceLayer virtual(Boolean virtual) {
        this.virtual = virtual;
        return this;
    }

    @NotNull
    @Schema(name="virtual", description="A virtual layer has no name and can't be used in GetMap requests and is only used for tree structure.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="virtual")
    public Boolean getVirtual() {
        return this.virtual;
    }

    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    public GeoServiceLayer maxScale(Double maxScale) {
        this.maxScale = maxScale;
        return this;
    }

    @Schema(name="maxScale", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maxScale")
    public Double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Double maxScale) {
        this.maxScale = maxScale;
    }

    public GeoServiceLayer minScale(Double minScale) {
        this.minScale = minScale;
        return this;
    }

    @Schema(name="minScale", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minScale")
    public Double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Double minScale) {
        this.minScale = minScale;
    }

    public GeoServiceLayer crs(Set<String> crs) {
        this.crs = crs;
        return this;
    }

    public GeoServiceLayer addCrsItem(String crsItem) {
        if (this.crs == null) {
            this.crs = new LinkedHashSet<String>();
        }
        this.crs.add(crsItem);
        return this;
    }

    @Schema(name="crs", description="Only the CRSes added by this layer, all parent CRSes are inherited.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="crs")
    public Set<String> getCrs() {
        return this.crs;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setCrs(Set<String> crs) {
        this.crs = crs;
    }

    public GeoServiceLayer latLonBoundingBox(Bounds latLonBoundingBox) {
        this.latLonBoundingBox = latLonBoundingBox;
        return this;
    }

    @Valid
    @Schema(name="latLonBoundingBox", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="latLonBoundingBox")
    public Bounds getLatLonBoundingBox() {
        return this.latLonBoundingBox;
    }

    public void setLatLonBoundingBox(Bounds latLonBoundingBox) {
        this.latLonBoundingBox = latLonBoundingBox;
    }

    public GeoServiceLayer styles(List<@Valid WMSStyle> styles) {
        this.styles = styles;
        return this;
    }

    public GeoServiceLayer addStylesItem(WMSStyle stylesItem) {
        if (this.styles == null) {
            this.styles = new ArrayList<WMSStyle>();
        }
        this.styles.add(stylesItem);
        return this;
    }

    @Valid
    @Schema(name="styles", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="styles")
    public @Valid List<@Valid WMSStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(List<@Valid WMSStyle> styles) {
        this.styles = styles;
    }

    public GeoServiceLayer queryable(Boolean queryable) {
        this.queryable = queryable;
        return this;
    }

    @Schema(name="queryable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="queryable")
    public Boolean getQueryable() {
        return this.queryable;
    }

    public void setQueryable(Boolean queryable) {
        this.queryable = queryable;
    }

    public GeoServiceLayer abstractText(String abstractText) {
        this.abstractText = abstractText;
        return this;
    }

    @Schema(name="abstractText", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="abstractText")
    public String getAbstractText() {
        return this.abstractText;
    }

    public void setAbstractText(String abstractText) {
        this.abstractText = abstractText;
    }

    public GeoServiceLayer children(List<String> children) {
        this.children = children;
        return this;
    }

    public GeoServiceLayer addChildrenItem(String childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<String>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @NotNull
    @Schema(name="children", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="children")
    public List<String> getChildren() {
        return this.children;
    }

    public void setChildren(List<String> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoServiceLayer geoServiceLayer = (GeoServiceLayer)o;
        return Objects.equals(this.id, geoServiceLayer.id) && Objects.equals(this.name, geoServiceLayer.name) && Objects.equals(this.root, geoServiceLayer.root) && Objects.equals(this.title, geoServiceLayer.title) && Objects.equals(this.virtual, geoServiceLayer.virtual) && Objects.equals(this.maxScale, geoServiceLayer.maxScale) && Objects.equals(this.minScale, geoServiceLayer.minScale) && Objects.equals(this.crs, geoServiceLayer.crs) && Objects.equals(this.latLonBoundingBox, geoServiceLayer.latLonBoundingBox) && Objects.equals(this.styles, geoServiceLayer.styles) && Objects.equals(this.queryable, geoServiceLayer.queryable) && Objects.equals(this.abstractText, geoServiceLayer.abstractText) && Objects.equals(this.children, geoServiceLayer.children);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.root, this.title, this.virtual, this.maxScale, this.minScale, this.crs, this.latLonBoundingBox, this.styles, this.queryable, this.abstractText, this.children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeoServiceLayer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    root: ").append(this.toIndentedString(this.root)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    virtual: ").append(this.toIndentedString(this.virtual)).append("\n");
        sb.append("    maxScale: ").append(this.toIndentedString(this.maxScale)).append("\n");
        sb.append("    minScale: ").append(this.toIndentedString(this.minScale)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    latLonBoundingBox: ").append(this.toIndentedString(this.latLonBoundingBox)).append("\n");
        sb.append("    styles: ").append(this.toIndentedString(this.styles)).append("\n");
        sb.append("    queryable: ").append(this.toIndentedString(this.queryable)).append("\n");
        sb.append("    abstractText: ").append(this.toIndentedString(this.abstractText)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

