/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.processing;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import javax.validation.constraints.NotNull;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.geometry.jts.WKTWriter2;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GeometryProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private GeometryProcessor() {
    }

    @NotNull
    public static String processGeometry(Object geometry, @NotNull Boolean simplifyGeometry, @NotNull Boolean linearizeGeomToWKT, MathTransform transform) {
        if (null == geometry) {
            return null;
        }
        if (Geometry.class.isAssignableFrom(geometry.getClass())) {
            if (null != transform) {
                geometry = GeometryProcessor.transformGeometry((Geometry)((Geometry)geometry), (MathTransform)transform);
            }
            if (simplifyGeometry.booleanValue()) {
                return GeometryProcessor.simplify((Geometry)((Geometry)geometry));
            }
            if (linearizeGeomToWKT.booleanValue()) {
                return GeometryProcessor.linearizeGeomToWKT((Geometry)((Geometry)geometry));
            }
        }
        return geometry.toString();
    }

    public static Geometry transformGeometry(@NotNull Geometry geometry, MathTransform transform) {
        if (null == transform) {
            return geometry;
        }
        try {
            return JTS.transform((Geometry)geometry, (MathTransform)transform);
        }
        catch (TransformException e) {
            logger.error("Failed to transform geometry", (Throwable)e);
            return geometry;
        }
    }

    private static String linearizeGeomToWKT(Geometry geometry) {
        WKTWriter writer = new WKTWriter(2);
        Object wkt = writer.write(geometry);
        if (((String)wkt).startsWith("LINEARRING")) {
            wkt = "LINESTRING" + ((String)wkt).substring("LINEARRING".length());
        }
        return wkt;
    }

    @NotNull
    private static String simplify(@NotNull Geometry geom) {
        double distanceTolerance;
        int megabytes = 1994752;
        logger.debug("PrecisionModel scale: {}", (Object)geom.getPrecisionModel().getScale());
        PrecisionModel pm = new PrecisionModel(geom.getPrecisionModel());
        GeometryPrecisionReducer gpr = new GeometryPrecisionReducer(pm);
        geom = gpr.reduce(geom);
        Geometry bbox = geom.getEnvelope();
        String geomTxt = geom.toText();
        for (distanceTolerance = 1.0; (geomTxt.getBytes(StandardCharsets.UTF_8).length > 1994752 || geom.getCoordinates().length > 600) && distanceTolerance < 9999.0; distanceTolerance = 10.0 * distanceTolerance) {
            logger.debug("Simplify selected feature geometry with distance of: {}", (Object)distanceTolerance);
            geom = TopologyPreservingSimplifier.simplify((Geometry)geom, (double)distanceTolerance);
            geom = gpr.reduce(geom);
            geomTxt = geom.toText();
        }
        if (distanceTolerance > 9999.0) {
            logger.debug("Maximum number of simplify cycles reached, returning bounding box instead");
            return bbox.toText();
        }
        return GeometryProcessor.linearizeGeomToWKT((Geometry)geom);
    }

    public static String geometryToJson(Geometry geom) {
        return GeoJSONWriter.toGeoJSON((Geometry)geom);
    }

    public static String geometryToWKT(@NotNull Geometry geom) {
        int dimension = geom.getDimension() > 1 ? geom.getDimension() : 2;
        WKTWriter2 writer = new WKTWriter2(dimension);
        return writer.write(geom);
    }

    public static Geometry wktToGeometry(String wkt) {
        if (null != wkt && wkt.length() > 1) {
            WKTReader2 reader = new WKTReader2();
            try {
                return reader.read(wkt);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }
}

