/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.helper;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.AttributeSettings;
import nl.b3p.tailormap.api.persistence.json.TMAttributeDescriptor;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class TMFeatureTypeHelper {
    public static boolean isEditable(Application application, AppTreeLayerNode appTreeLayerNode, TMFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        boolean editable = false;
        if (featureType.isWriteable()) {
            AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
            editable = Boolean.TRUE.equals(appLayerSettings.getEditable());
        }
        return editable;
    }

    public static Set<String> getHiddenAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        HashSet<String> hiddenAttributes = new HashSet<String>();
        Optional.ofNullable(featureType.getSettings().getHideAttributes()).ifPresent(hiddenAttributes::addAll);
        Optional.ofNullable(appLayerSettings.getHideAttributes()).ifPresent(hiddenAttributes::addAll);
        return hiddenAttributes;
    }

    public static Set<String> getReadOnlyAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        HashSet<String> readOnlyAttributes = new HashSet<String>();
        Optional.ofNullable(featureType.getSettings().getReadOnlyAttributes()).ifPresent(readOnlyAttributes::addAll);
        Optional.ofNullable(appLayerSettings.getReadOnlyAttributes()).ifPresent(readOnlyAttributes::addAll);
        return readOnlyAttributes;
    }

    public static Map<String, Pair<TMAttributeDescriptor, AttributeSettings>> getConfiguredAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        LinkedHashSet<Object> finalAttributeOrder;
        LinkedHashMap<String, TMAttributeDescriptor> originalAttributesOrder = new LinkedHashMap<String, TMAttributeDescriptor>();
        for (TMAttributeDescriptor attributeDescriptor : featureType.getAttributes()) {
            originalAttributesOrder.put(attributeDescriptor.getName(), attributeDescriptor);
        }
        if (featureType.getSettings().getAttributeOrder().isEmpty()) {
            finalAttributeOrder = new LinkedHashSet(originalAttributesOrder.keySet());
        } else {
            finalAttributeOrder = new LinkedHashSet(featureType.getSettings().getAttributeOrder());
            finalAttributeOrder.retainAll(originalAttributesOrder.keySet());
            if (finalAttributeOrder.size() != originalAttributesOrder.size()) {
                finalAttributeOrder.addAll(originalAttributesOrder.keySet());
            }
        }
        TMFeatureTypeHelper.getHiddenAttributes((TMFeatureType)featureType, (AppLayerSettings)appLayerSettings).forEach(finalAttributeOrder::remove);
        Map attributeSettings = featureType.getSettings().getAttributeSettings();
        LinkedHashMap<String, Pair<TMAttributeDescriptor, AttributeSettings>> result = new LinkedHashMap<String, Pair<TMAttributeDescriptor, AttributeSettings>>();
        for (String string : finalAttributeOrder) {
            AttributeSettings settings = Optional.ofNullable((AttributeSettings)attributeSettings.get(string)).orElseGet(AttributeSettings::new);
            TMAttributeDescriptor attributeDescriptor = (TMAttributeDescriptor)originalAttributesOrder.get(string);
            result.put(string, (Pair<TMAttributeDescriptor, AttributeSettings>)Pair.of((Object)attributeDescriptor, (Object)settings));
        }
        return result;
    }

    public static Set<TMAttributeDescriptor> getNonHiddenAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        Set hiddenAttributes = TMFeatureTypeHelper.getHiddenAttributes((TMFeatureType)featureType, (AppLayerSettings)appLayerSettings);
        return featureType.getAttributes().stream().filter(attributeDescriptor -> !hiddenAttributes.contains(attributeDescriptor.getName())).collect(Collectors.toSet());
    }

    public static Set<String> getNonHiddenAttributeNames(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        return TMFeatureTypeHelper.getNonHiddenAttributes((TMFeatureType)featureType, (AppLayerSettings)appLayerSettings).stream().map(TMAttributeDescriptor::getName).collect(Collectors.toSet());
    }
}

