/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import java.io.Serializable;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.persistence.Configuration;
import nl.b3p.tailormap.api.repository.ConfigurationRepository;
import nl.b3p.tailormap.api.viewer.model.ConfigResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
public class ConfigurationController {
    private final ConfigurationRepository configurationRepository;

    public ConfigurationController(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    @GetMapping(path={"${tailormap-api.base-path}/config/{key}"}, produces={"application/json"})
    public ResponseEntity<Serializable> getConfig(@PathVariable String key) {
        Configuration config = (Configuration)this.configurationRepository.getAvailableForViewer(key).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
        ConfigResponse response = new ConfigResponse();
        response.setKey(key);
        response.setValue(config.getValue());
        response.setObject((Object)config.getJsonValue());
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)response);
    }
}

