/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.PreRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.Pattern;
import nl.b3p.tailormap.api.persistence.User;
import nl.b3p.tailormap.api.persistence.listener.EntityEventPublisher;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;

@Entity
@Table(name="groups")
@EntityListeners(value={EntityEventPublisher.class})
public class Group
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    public static final String ANONYMOUS = "anonymous";
    public static final String AUTHENTICATED = "authenticated";
    public static final String ADMIN = "admin";
    public static final String ACTUATOR = "actuator";
    @Id
    @Pattern(regexp="^[a-zA-Z0-9-_]+", message="Group name must consist of alphanumeric characters, underscore or -")
    private @Pattern(regexp="^[a-zA-Z0-9-_]+", message="Group name must consist of alphanumeric characters, underscore or -") String name;
    @Version
    private Long version;
    private boolean systemGroup;
    private String description;
    @Column(columnDefinition="text")
    private String notes;
    @ManyToMany(mappedBy="groups")
    private Set<User> members;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public Group() {
        this.$$_hibernate_write_members(new HashSet());
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public Group setName(String name) {
        this.$$_hibernate_write_name(name);
        return this;
    }

    public Long getVersion() {
        return this.$$_hibernate_read_version();
    }

    public Group setVersion(Long version) {
        this.$$_hibernate_write_version(version);
        return this;
    }

    public boolean isSystemGroup() {
        return this.$$_hibernate_read_systemGroup();
    }

    public Group setSystemGroup(boolean systemGroup) {
        this.$$_hibernate_write_systemGroup(systemGroup);
        return this;
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public Group setDescription(String title) {
        this.$$_hibernate_write_description(title);
        return this;
    }

    public String getNotes() {
        return this.$$_hibernate_read_notes();
    }

    public Group setNotes(String notes) {
        this.$$_hibernate_write_notes(notes);
        return this;
    }

    public Set<User> getMembers() {
        return this.$$_hibernate_read_members();
    }

    public Group setMembers(Set<User> members) {
        this.$$_hibernate_write_members(members);
        return this;
    }

    @PreRemove
    private void removeMembers() {
        for (User user : this.$$_hibernate_read_members()) {
            user.getGroups().remove(this);
        }
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Group group = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                Group group = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("members");
                if (this.members != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.members == null || this.members instanceof PersistentCollection && !((PersistentCollection)this.members).wasInitialized() || n == this.members.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                Group group = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("members");
                if (this.members != null || n == -1) break block1;
                dirtyTracker.add("members");
                break block0;
            }
            if (this.members == null || this.members instanceof PersistentCollection && !((PersistentCollection)this.members).wasInitialized() || n == this.members.size()) break block0;
            dirtyTracker.add("members");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            Group group = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("members")) break block3;
            if (this.members == null || this.members instanceof PersistentCollection && !((PersistentCollection)this.members).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("members", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("members", this.members.size());
            }
        }
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (Object)l, (Object)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)this.version, (Object)l);
            return;
        }
        this.version = l;
    }

    public boolean $$_hibernate_read_systemGroup() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.systemGroup = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "systemGroup", this.systemGroup);
        }
        return this.systemGroup;
    }

    public void $$_hibernate_write_systemGroup(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"systemGroup", (boolean)bl, (boolean)this.systemGroup)) {
            this.$$_hibernate_trackChange("systemGroup");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.systemGroup = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "systemGroup", this.systemGroup, bl);
            return;
        }
        this.systemGroup = bl;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"description", (Object)string, (Object)this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public String $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", (Object)this.notes);
        }
        return this.notes;
    }

    public void $$_hibernate_write_notes(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"notes", (Object)string, (Object)this.notes)) {
            this.$$_hibernate_trackChange("notes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "notes", (Object)this.notes, (Object)string);
            return;
        }
        this.notes = string;
    }

    public Set $$_hibernate_read_members() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.members = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "members", (Object)this.members);
        }
        return this.members;
    }

    public void $$_hibernate_write_members(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.members = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "members", (Object)this.members, (Object)set);
            return;
        }
        this.members = set;
    }
}

