/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.persistence.json.GeoServiceDefaultLayerSettings;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayerSettings;
import nl.b3p.tailormap.api.persistence.json.GeoServiceSettings;
import nl.b3p.tailormap.api.persistence.json.ServicePublishingSettings;

@Schema(name="GeoServiceSettings", description="Settings applying to a GeoService.")
public class GeoServiceSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ServerTypeEnum serverType = ServerTypeEnum.AUTO;
    private Boolean useProxy = false;
    private ServicePublishingSettings publishing;
    private GeoServiceDefaultLayerSettings defaultLayerSettings = null;
    @Valid
    private Map<String, GeoServiceLayerSettings> layerSettings = new HashMap();
    private String xyzCrs = null;

    public GeoServiceSettings serverType(ServerTypeEnum serverType) {
        this.serverType = serverType;
        return this;
    }

    @Schema(name="serverType", description="Server type to use for vendor-specific capabilities (high DPI, legends, etc.)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="serverType")
    public ServerTypeEnum getServerType() {
        return this.serverType;
    }

    public void setServerType(ServerTypeEnum serverType) {
        this.serverType = serverType;
    }

    public GeoServiceSettings useProxy(Boolean useProxy) {
        this.useProxy = useProxy;
        return this;
    }

    @Schema(name="useProxy", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="useProxy")
    public Boolean getUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(Boolean useProxy) {
        this.useProxy = useProxy;
    }

    public GeoServiceSettings publishing(ServicePublishingSettings publishing) {
        this.publishing = publishing;
        return this;
    }

    @Valid
    @Schema(name="publishing", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="publishing")
    public ServicePublishingSettings getPublishing() {
        return this.publishing;
    }

    public void setPublishing(ServicePublishingSettings publishing) {
        this.publishing = publishing;
    }

    public GeoServiceSettings defaultLayerSettings(GeoServiceDefaultLayerSettings defaultLayerSettings) {
        this.defaultLayerSettings = defaultLayerSettings;
        return this;
    }

    @Valid
    @Schema(name="defaultLayerSettings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="defaultLayerSettings")
    public GeoServiceDefaultLayerSettings getDefaultLayerSettings() {
        return this.defaultLayerSettings;
    }

    public void setDefaultLayerSettings(GeoServiceDefaultLayerSettings defaultLayerSettings) {
        this.defaultLayerSettings = defaultLayerSettings;
    }

    public GeoServiceSettings layerSettings(Map<String, GeoServiceLayerSettings> layerSettings) {
        this.layerSettings = layerSettings;
        return this;
    }

    public GeoServiceSettings putLayerSettingsItem(String key, GeoServiceLayerSettings layerSettingsItem) {
        if (this.layerSettings == null) {
            this.layerSettings = new HashMap();
        }
        this.layerSettings.put(key, layerSettingsItem);
        return this;
    }

    @Valid
    @Schema(name="layerSettings", example="{\"begroeidterreindeel\":{\"title\":\"laag 1\"},\"begroeidterreindeel_2\":{\"title\":\"laag 2\"},\"otherLayer\":{\"hiDpiDisabled\":true}}", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="layerSettings")
    public Map<String, GeoServiceLayerSettings> getLayerSettings() {
        return this.layerSettings;
    }

    public void setLayerSettings(Map<String, GeoServiceLayerSettings> layerSettings) {
        this.layerSettings = layerSettings;
    }

    public GeoServiceSettings xyzCrs(String xyzCrs) {
        this.xyzCrs = xyzCrs;
        return this;
    }

    @Schema(name="xyzCrs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="xyzCrs")
    public String getXyzCrs() {
        return this.xyzCrs;
    }

    public void setXyzCrs(String xyzCrs) {
        this.xyzCrs = xyzCrs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoServiceSettings geoServiceSettings = (GeoServiceSettings)o;
        return Objects.equals(this.serverType, geoServiceSettings.serverType) && Objects.equals(this.useProxy, geoServiceSettings.useProxy) && Objects.equals(this.publishing, geoServiceSettings.publishing) && Objects.equals(this.defaultLayerSettings, geoServiceSettings.defaultLayerSettings) && Objects.equals(this.layerSettings, geoServiceSettings.layerSettings) && Objects.equals(this.xyzCrs, geoServiceSettings.xyzCrs);
    }

    public int hashCode() {
        return Objects.hash(this.serverType, this.useProxy, this.publishing, this.defaultLayerSettings, this.layerSettings, this.xyzCrs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeoServiceSettings {\n");
        sb.append("    serverType: ").append(this.toIndentedString((Object)this.serverType)).append("\n");
        sb.append("    useProxy: ").append(this.toIndentedString((Object)this.useProxy)).append("\n");
        sb.append("    publishing: ").append(this.toIndentedString((Object)this.publishing)).append("\n");
        sb.append("    defaultLayerSettings: ").append(this.toIndentedString((Object)this.defaultLayerSettings)).append("\n");
        sb.append("    layerSettings: ").append(this.toIndentedString((Object)this.layerSettings)).append("\n");
        sb.append("    xyzCrs: ").append(this.toIndentedString((Object)this.xyzCrs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

