package nl.b3p.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.tailormap.api.persistence.json.AppI18nSettings;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppUiSettings;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Settings applying to a viewer application.
 */

@Schema(name = "AppSettings", description = "Settings applying to a viewer application.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen")
public class AppSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private AppI18nSettings i18nSettings;

  private AppUiSettings uiSettings;

  @Valid
  private Map<String, AppLayerSettings> layerSettings = new HashMap<>();

  public AppSettings i18nSettings(AppI18nSettings i18nSettings) {
    this.i18nSettings = i18nSettings;
    return this;
  }

  /**
   * Get i18nSettings
   * @return i18nSettings
  */
  @Valid 
  @Schema(name = "i18nSettings", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("i18nSettings")
  public AppI18nSettings getI18nSettings() {
    return i18nSettings;
  }

  public void setI18nSettings(AppI18nSettings i18nSettings) {
    this.i18nSettings = i18nSettings;
  }

  public AppSettings uiSettings(AppUiSettings uiSettings) {
    this.uiSettings = uiSettings;
    return this;
  }

  /**
   * Get uiSettings
   * @return uiSettings
  */
  @Valid 
  @Schema(name = "uiSettings", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("uiSettings")
  public AppUiSettings getUiSettings() {
    return uiSettings;
  }

  public void setUiSettings(AppUiSettings uiSettings) {
    this.uiSettings = uiSettings;
  }

  public AppSettings layerSettings(Map<String, AppLayerSettings> layerSettings) {
    this.layerSettings = layerSettings;
    return this;
  }

  public AppSettings putLayerSettingsItem(String key, AppLayerSettings layerSettingsItem) {
    if (this.layerSettings == null) {
      this.layerSettings = new HashMap<>();
    }
    this.layerSettings.put(key, layerSettingsItem);
    return this;
  }

  /**
   * Map of id of an AppTreeLayerNode to its' settings.
   * @return layerSettings
  */
  @Valid 
  @Schema(name = "layerSettings", description = "Map of id of an AppTreeLayerNode to its' settings.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("layerSettings")
  public Map<String, AppLayerSettings> getLayerSettings() {
    return layerSettings;
  }

  public void setLayerSettings(Map<String, AppLayerSettings> layerSettings) {
    this.layerSettings = layerSettings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppSettings appSettings = (AppSettings) o;
    return Objects.equals(this.i18nSettings, appSettings.i18nSettings) &&
        Objects.equals(this.uiSettings, appSettings.uiSettings) &&
        Objects.equals(this.layerSettings, appSettings.layerSettings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(i18nSettings, uiSettings, layerSettings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppSettings {\n");
    sb.append("    i18nSettings: ").append(toIndentedString(i18nSettings)).append("\n");
    sb.append("    uiSettings: ").append(toIndentedString(uiSettings)).append("\n");
    sb.append("    layerSettings: ").append(toIndentedString(layerSettings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

