/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import nl.b3p.tailormap.api.viewer.model.LoginConfigurationSsoLinksInner;

public class LoginConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean hideLoginForm;
    @Valid
    private @Valid List<@Valid LoginConfigurationSsoLinksInner> ssoLinks;

    public LoginConfiguration hideLoginForm(Boolean hideLoginForm) {
        this.hideLoginForm = hideLoginForm;
        return this;
    }

    @Schema(name="hideLoginForm", description="If set, should hide the login form for any user-facing applications.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hideLoginForm")
    public Boolean getHideLoginForm() {
        return this.hideLoginForm;
    }

    public void setHideLoginForm(Boolean hideLoginForm) {
        this.hideLoginForm = hideLoginForm;
    }

    public LoginConfiguration ssoLinks(List<@Valid LoginConfigurationSsoLinksInner> ssoLinks) {
        this.ssoLinks = ssoLinks;
        return this;
    }

    public LoginConfiguration addSsoLinksItem(LoginConfigurationSsoLinksInner ssoLinksItem) {
        if (this.ssoLinks == null) {
            this.ssoLinks = new ArrayList<LoginConfigurationSsoLinksInner>();
        }
        this.ssoLinks.add(ssoLinksItem);
        return this;
    }

    @Valid
    @Schema(name="ssoLinks", description="Lists alternative SSO links.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="ssoLinks")
    public @Valid List<@Valid LoginConfigurationSsoLinksInner> getSsoLinks() {
        return this.ssoLinks;
    }

    public void setSsoLinks(List<@Valid LoginConfigurationSsoLinksInner> ssoLinks) {
        this.ssoLinks = ssoLinks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginConfiguration loginConfiguration = (LoginConfiguration)o;
        return Objects.equals(this.hideLoginForm, loginConfiguration.hideLoginForm) && Objects.equals(this.ssoLinks, loginConfiguration.ssoLinks);
    }

    public int hashCode() {
        return Objects.hash(this.hideLoginForm, this.ssoLinks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginConfiguration {\n");
        sb.append("    hideLoginForm: ").append(this.toIndentedString(this.hideLoginForm)).append("\n");
        sb.append("    ssoLinks: ").append(this.toIndentedString(this.ssoLinks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

