/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.featuresources;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceHelper;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.helper.GeoToolsHelper;
import nl.b3p.tailormap.api.persistence.json.ServiceAuthentication;
import nl.b3p.tailormap.api.persistence.json.TMFeatureTypeInfo;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.locationtech.jts.geom.Envelope;

public class WFSFeatureSourceHelper
extends FeatureSourceHelper {
    public DataStore createDataStore(TMFeatureSource tmfs, Integer timeout) throws IOException {
        Object wfsUrl;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (timeout != null) {
            params.put(WFSDataStoreFactory.TIMEOUT.key, timeout);
        }
        if (!((String)(wfsUrl = tmfs.getUrl())).endsWith("&") && !((String)wfsUrl).endsWith("?")) {
            wfsUrl = (String)wfsUrl + (((String)wfsUrl).contains("?") ? "&" : "?");
        }
        if (!((String)(wfsUrl = (String)wfsUrl + "REQUEST=GetCapabilities&SERVICE=WFS")).toUpperCase(Locale.ROOT).contains("VERSION")) {
            wfsUrl = (String)wfsUrl + "&VERSION=1.1.0";
        }
        params.put(WFSDataStoreFactory.URL.key, wfsUrl);
        ServiceAuthentication authentication = tmfs.getAuthentication();
        if (authentication != null) {
            if (authentication.getMethod() != ServiceAuthentication.MethodEnum.PASSWORD) {
                throw new IllegalArgumentException(authentication.getMethod().getValue());
            }
            params.put(WFSDataStoreFactory.USERNAME.key, authentication.getUsername());
            params.put(WFSDataStoreFactory.PASSWORD.key, authentication.getPassword());
        }
        return this.openDatastore(params, WFSDataStoreFactory.PASSWORD.key);
    }

    protected TMFeatureTypeInfo getFeatureTypeInfo(TMFeatureType pft, ResourceInfo info, SimpleFeatureSource gtFs) {
        TMFeatureTypeInfo tmInfo = super.getFeatureTypeInfo(pft, info, gtFs);
        if (info instanceof FeatureTypeInfo) {
            FeatureTypeInfo ftInfo = (FeatureTypeInfo)info;
            tmInfo.schema(info.getSchema()).wgs84BoundingBox(GeoToolsHelper.fromEnvelope((Envelope)ftInfo.getWGS84BoundingBox())).defaultSrs(ftInfo.getDefaultSRS()).otherSrs(Set.copyOf(ftInfo.getOtherSRS())).outputFormats(ftInfo.getOutputFormats()).abstractText(ftInfo.getAbstract());
        }
        return tmInfo;
    }
}

