/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AppTreeNode;

@Schema(name="AppContent", description="Configuration for including content (layers) in an application.")
public class AppContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    private List<AppTreeNode> baseLayerNodes;
    @Valid
    private List<AppTreeNode> layerNodes;

    public AppContent baseLayerNodes(List<AppTreeNode> baseLayerNodes) {
        this.baseLayerNodes = baseLayerNodes;
        return this;
    }

    public AppContent addBaseLayerNodesItem(AppTreeNode baseLayerNodesItem) {
        if (this.baseLayerNodes == null) {
            this.baseLayerNodes = new ArrayList();
        }
        this.baseLayerNodes.add(baseLayerNodesItem);
        return this;
    }

    @Valid
    @Schema(name="baseLayerNodes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="baseLayerNodes")
    public List<AppTreeNode> getBaseLayerNodes() {
        return this.baseLayerNodes;
    }

    public void setBaseLayerNodes(List<AppTreeNode> baseLayerNodes) {
        this.baseLayerNodes = baseLayerNodes;
    }

    public AppContent layerNodes(List<AppTreeNode> layerNodes) {
        this.layerNodes = layerNodes;
        return this;
    }

    public AppContent addLayerNodesItem(AppTreeNode layerNodesItem) {
        if (this.layerNodes == null) {
            this.layerNodes = new ArrayList();
        }
        this.layerNodes.add(layerNodesItem);
        return this;
    }

    @Valid
    @Schema(name="layerNodes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="layerNodes")
    public List<AppTreeNode> getLayerNodes() {
        return this.layerNodes;
    }

    public void setLayerNodes(List<AppTreeNode> layerNodes) {
        this.layerNodes = layerNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppContent appContent = (AppContent)o;
        return Objects.equals(this.baseLayerNodes, appContent.baseLayerNodes) && Objects.equals(this.layerNodes, appContent.layerNodes);
    }

    public int hashCode() {
        return Objects.hash(this.baseLayerNodes, this.layerNodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppContent {\n");
        sb.append("    baseLayerNodes: ").append(this.toIndentedString((Object)this.baseLayerNodes)).append("\n");
        sb.append("    layerNodes: ").append(this.toIndentedString((Object)this.layerNodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

