/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="LayerTreeNode", description="Grouping of layers in a tree structure.")
public class LayerTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String appLayerId;
    private Boolean root;
    private String name;
    private String description;
    @Valid
    private List<String> childrenIds;

    public LayerTreeNode id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="A unique identifier across all tree nodes.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LayerTreeNode appLayerId(String appLayerId) {
        this.appLayerId = appLayerId;
        return this;
    }

    @Schema(name="appLayerId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="appLayerId")
    public String getAppLayerId() {
        return this.appLayerId;
    }

    public void setAppLayerId(String appLayerId) {
        this.appLayerId = appLayerId;
    }

    public LayerTreeNode root(Boolean root) {
        this.root = root;
        return this;
    }

    @Schema(name="root", description="Only a single node in a tree will have this set to true.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="root")
    public Boolean getRoot() {
        return this.root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    public LayerTreeNode name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", description="Display name of this tree node. If appLayerId is present, this is the title of that AppLayer.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LayerTreeNode description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description for this node entered by application admin.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LayerTreeNode childrenIds(List<String> childrenIds) {
        this.childrenIds = childrenIds;
        return this;
    }

    public LayerTreeNode addChildrenIdsItem(String childrenIdsItem) {
        if (this.childrenIds == null) {
            this.childrenIds = new ArrayList();
        }
        this.childrenIds.add(childrenIdsItem);
        return this;
    }

    @Schema(name="childrenIds", description="Ordered list of ids of LayerTreeNodes that are children of this node.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="childrenIds")
    public List<String> getChildrenIds() {
        return this.childrenIds;
    }

    public void setChildrenIds(List<String> childrenIds) {
        this.childrenIds = childrenIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayerTreeNode layerTreeNode = (LayerTreeNode)o;
        return Objects.equals(this.id, layerTreeNode.id) && Objects.equals(this.appLayerId, layerTreeNode.appLayerId) && Objects.equals(this.root, layerTreeNode.root) && Objects.equals(this.name, layerTreeNode.name) && Objects.equals(this.description, layerTreeNode.description) && Objects.equals(this.childrenIds, layerTreeNode.childrenIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.appLayerId, this.root, this.name, this.description, this.childrenIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LayerTreeNode {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    appLayerId: ").append(this.toIndentedString((Object)this.appLayerId)).append("\n");
        sb.append("    root: ").append(this.toIndentedString((Object)this.root)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    childrenIds: ").append(this.toIndentedString((Object)this.childrenIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

