package nl.b3p.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.tailormap.api.persistence.json.TMGeometryType;
import nl.b3p.tailormap.api.viewer.model.Attribute;
import nl.b3p.tailormap.api.viewer.model.LayerDetailsForm;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * All details of an app layer.
 */

@Schema(name = "LayerDetails", description = "All details of an app layer.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.4.0")
public class LayerDetails implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String featureTypeName;

  private String serviceId;

  private String geometryAttribute;

  private Integer geometryAttributeIndex;

  private TMGeometryType geometryType;

  private Boolean editable = false;

  private LayerDetailsForm form = null;

  @Valid
  private List<@Valid Attribute> attributes;

  public LayerDetails id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @NotNull 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public LayerDetails featureTypeName(String featureTypeName) {
    this.featureTypeName = featureTypeName;
    return this;
  }

  /**
   * Get featureTypeName
   * @return featureTypeName
  */
  
  @Schema(name = "featureTypeName", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("featureTypeName")
  public String getFeatureTypeName() {
    return featureTypeName;
  }

  public void setFeatureTypeName(String featureTypeName) {
    this.featureTypeName = featureTypeName;
  }

  public LayerDetails serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

  /**
   * Get serviceId
   * @return serviceId
  */
  @NotNull 
  @Schema(name = "serviceId", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("serviceId")
  public String getServiceId() {
    return serviceId;
  }

  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }

  public LayerDetails geometryAttribute(String geometryAttribute) {
    this.geometryAttribute = geometryAttribute;
    return this;
  }

  /**
   * Get geometryAttribute
   * @return geometryAttribute
  */
  
  @Schema(name = "geometryAttribute", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("geometryAttribute")
  public String getGeometryAttribute() {
    return geometryAttribute;
  }

  public void setGeometryAttribute(String geometryAttribute) {
    this.geometryAttribute = geometryAttribute;
  }

  public LayerDetails geometryAttributeIndex(Integer geometryAttributeIndex) {
    this.geometryAttributeIndex = geometryAttributeIndex;
    return this;
  }

  /**
   * index of the geometryAttribute in the array of attributes.
   * @return geometryAttributeIndex
  */
  
  @Schema(name = "geometryAttributeIndex", description = "index of the geometryAttribute in the array of attributes.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("geometryAttributeIndex")
  public Integer getGeometryAttributeIndex() {
    return geometryAttributeIndex;
  }

  public void setGeometryAttributeIndex(Integer geometryAttributeIndex) {
    this.geometryAttributeIndex = geometryAttributeIndex;
  }

  public LayerDetails geometryType(TMGeometryType geometryType) {
    this.geometryType = geometryType;
    return this;
  }

  /**
   * Get geometryType
   * @return geometryType
  */
  @Valid 
  @Schema(name = "geometryType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("geometryType")
  public TMGeometryType getGeometryType() {
    return geometryType;
  }

  public void setGeometryType(TMGeometryType geometryType) {
    this.geometryType = geometryType;
  }

  public LayerDetails editable(Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * Get editable
   * @return editable
  */
  
  @Schema(name = "editable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("editable")
  public Boolean getEditable() {
    return editable;
  }

  public void setEditable(Boolean editable) {
    this.editable = editable;
  }

  public LayerDetails form(LayerDetailsForm form) {
    this.form = form;
    return this;
  }

  /**
   * Get form
   * @return form
  */
  @Valid 
  @Schema(name = "form", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("form")
  public LayerDetailsForm getForm() {
    return form;
  }

  public void setForm(LayerDetailsForm form) {
    this.form = form;
  }

  public LayerDetails attributes(List<@Valid Attribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  public LayerDetails addAttributesItem(Attribute attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

  /**
   *  Array with attributes. **note** that the ordering of this array is determined in the backend and does not need to coincide with the actual data in the data source. 
   * @return attributes
  */
  @Valid 
  @Schema(name = "attributes", description = " Array with attributes. **note** that the ordering of this array is determined in the backend and does not need to coincide with the actual data in the data source. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attributes")
  public List<@Valid Attribute> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<@Valid Attribute> attributes) {
    this.attributes = attributes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LayerDetails layerDetails = (LayerDetails) o;
    return Objects.equals(this.id, layerDetails.id) &&
        Objects.equals(this.featureTypeName, layerDetails.featureTypeName) &&
        Objects.equals(this.serviceId, layerDetails.serviceId) &&
        Objects.equals(this.geometryAttribute, layerDetails.geometryAttribute) &&
        Objects.equals(this.geometryAttributeIndex, layerDetails.geometryAttributeIndex) &&
        Objects.equals(this.geometryType, layerDetails.geometryType) &&
        Objects.equals(this.editable, layerDetails.editable) &&
        Objects.equals(this.form, layerDetails.form) &&
        Objects.equals(this.attributes, layerDetails.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, featureTypeName, serviceId, geometryAttribute, geometryAttributeIndex, geometryType, editable, form, attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LayerDetails {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    featureTypeName: ").append(toIndentedString(featureTypeName)).append("\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    geometryAttribute: ").append(toIndentedString(geometryAttribute)).append("\n");
    sb.append("    geometryAttributeIndex: ").append(toIndentedString(geometryAttributeIndex)).append("\n");
    sb.append("    geometryType: ").append(toIndentedString(geometryType)).append("\n");
    sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
    sb.append("    form: ").append(toIndentedString(form)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

