/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.configuration.dev;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import nl.b3p.tailormap.api.geotools.featuresources.JDBCFeatureSourceHelper;
import nl.b3p.tailormap.api.geotools.featuresources.WFSFeatureSourceHelper;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.Catalog;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.Group;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.persistence.User;
import nl.b3p.tailormap.api.persistence.helper.GeoServiceHelper;
import nl.b3p.tailormap.api.persistence.json.AppContent;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppSettings;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.AppTreeLevelNode;
import nl.b3p.tailormap.api.persistence.json.AttributeSettings;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRule;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRuleDecision;
import nl.b3p.tailormap.api.persistence.json.Bounds;
import nl.b3p.tailormap.api.persistence.json.CatalogNode;
import nl.b3p.tailormap.api.persistence.json.FeatureTypeRef;
import nl.b3p.tailormap.api.persistence.json.GeoServiceDefaultLayerSettings;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayerSettings;
import nl.b3p.tailormap.api.persistence.json.GeoServiceProtocol;
import nl.b3p.tailormap.api.persistence.json.GeoServiceSettings;
import nl.b3p.tailormap.api.persistence.json.JDBCConnectionProperties;
import nl.b3p.tailormap.api.persistence.json.ServiceAuthentication;
import nl.b3p.tailormap.api.persistence.json.TailormapObjectRef;
import nl.b3p.tailormap.api.persistence.json.TileLayerHiDpiMode;
import nl.b3p.tailormap.api.repository.ApplicationRepository;
import nl.b3p.tailormap.api.repository.CatalogRepository;
import nl.b3p.tailormap.api.repository.ConfigurationRepository;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.repository.GeoServiceRepository;
import nl.b3p.tailormap.api.repository.GroupRepository;
import nl.b3p.tailormap.api.repository.UserRepository;
import nl.b3p.tailormap.api.security.InternalAdminAuthentication;
import nl.b3p.tailormap.api.viewer.model.Component;
import nl.b3p.tailormap.api.viewer.model.ComponentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.transaction.annotation.Transactional;

@Configuration
@ConditionalOnProperty(name={"tailormap-api.database.populate-testdata"}, havingValue="true")
public class PopulateTestData {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${spatial.dbs.connect:false}")
    private boolean connectToSpatialDbs;
    @Value(value="${spatial.dbs.localhost:true}")
    private boolean connectToSpatialDbsAtLocalhost;
    @Value(value="${tailormap-api.database.populate-testdata.admin-hashed-password}")
    private String adminHashedPassword;
    @Value(value="${tailormap-api.database.populate-testdata.exit:false}")
    private boolean exit;
    @Value(value="${MAP5_URL:#{null}}")
    private String map5url;
    private final ApplicationContext appContext;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;
    private final CatalogRepository catalogRepository;
    private final GeoServiceRepository geoServiceRepository;
    private final GeoServiceHelper geoServiceHelper;
    private final FeatureSourceRepository featureSourceRepository;
    private final ApplicationRepository applicationRepository;
    private final ConfigurationRepository configurationRepository;

    public PopulateTestData(ApplicationContext appContext, UserRepository userRepository, GroupRepository groupRepository, CatalogRepository catalogRepository, GeoServiceRepository geoServiceRepository, GeoServiceHelper geoServiceHelper, FeatureSourceRepository featureSourceRepository, ApplicationRepository applicationRepository, ConfigurationRepository configurationRepository) {
        this.appContext = appContext;
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
        this.catalogRepository = catalogRepository;
        this.geoServiceRepository = geoServiceRepository;
        this.geoServiceHelper = geoServiceHelper;
        this.featureSourceRepository = featureSourceRepository;
        this.applicationRepository = applicationRepository;
        this.configurationRepository = configurationRepository;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    @Transactional
    public void populate() throws Exception {
        InternalAdminAuthentication.setInSecurityContext();
        try {
            this.createTestUsersAndGroups();
            this.createTestConfiguration();
        }
        finally {
            InternalAdminAuthentication.clearSecurityContextAuthentication();
        }
        if (this.exit) {
            new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SpringApplication.exit((ApplicationContext)this.appContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
                System.exit(0);
            }).start();
        }
    }

    public void createTestUsersAndGroups() throws NoSuchElementException {
        Group groupFoo = new Group().setName("test-foo").setDescription("Used for integration tests.");
        this.groupRepository.save(groupFoo);
        Group groupBar = new Group().setName("test-bar").setDescription("Used for integration tests.");
        this.groupRepository.save(groupBar);
        Group groupBaz = new Group().setName("test-baz").setDescription("Used for integration tests.");
        this.groupRepository.save(groupBaz);
        User u = new User().setUsername("user").setPassword("{noop}user").setEmail("user@example.com");
        u.getGroups().addAll(List.of(groupFoo, groupBar, groupBaz));
        this.userRepository.save(u);
        u = new User().setUsername("tm-admin").setPassword(this.adminHashedPassword);
        u.getGroups().add((Group)this.groupRepository.findById("admin").orElseThrow());
        this.userRepository.save(u);
    }

    public void createTestConfiguration() throws Exception {
        Catalog catalog = (Catalog)this.catalogRepository.findById("main").orElseThrow();
        CatalogNode rootCatalogNode = catalog.getNodes().get(0);
        CatalogNode catalogNode = new CatalogNode().id("test").title("Test services");
        rootCatalogNode.addChildrenItem(catalogNode.getId());
        catalog.getNodes().add(catalogNode);
        List<AuthorizationRule> rule = List.of(new AuthorizationRule().groupName("anonymous").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)));
        List<AuthorizationRule> ruleLoggedIn = List.of(new AuthorizationRule().groupName("authenticated").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)));
        String osmAttribution = "&copy; <a href=\"https://www.openstreetmap.org/copyright\">OpenStreetMap</a> contributors";
        Bounds rdTileGridExtent = new Bounds().minx(-285401.92).maxx(595401.92).miny(22598.08).maxy(903401.92);
        List<GeoService> services = List.of(new GeoService().setId("osm").setProtocol(GeoServiceProtocol.XYZ).setTitle("OSM").setUrl("https://tile.openstreetmap.org/{z}/{x}/{y}.png").setAuthorizationRules(rule).setSettings(new GeoServiceSettings().xyzCrs("EPSG:3857").layerSettings(Map.of("xyz", new GeoServiceLayerSettings().attribution(osmAttribution).maxZoom(19)))), new GeoService().setId("snapshot-geoserver").setProtocol(GeoServiceProtocol.WMS).setTitle("Test GeoServer").setUrl("https://snapshot.tailormap.nl/geoserver/wms").setAuthorizationRules(rule).setPublished(true), new GeoService().setId("filtered-snapshot-geoserver").setProtocol(GeoServiceProtocol.WMS).setTitle("Test GeoServer (with authorization rules)").setUrl("https://snapshot.tailormap.nl/geoserver/wms").setAuthorizationRules(List.of(new AuthorizationRule().groupName("test-foo").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)), new AuthorizationRule().groupName("test-baz").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)))).setSettings(new GeoServiceSettings().layerSettings(Map.of("BGT", new GeoServiceLayerSettings().addAuthorizationRulesItem(new AuthorizationRule().groupName("test-foo").decisions(Map.of("read", AuthorizationRuleDecision.DENY))).addAuthorizationRulesItem(new AuthorizationRule().groupName("test-baz").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)))))).setPublished(true), new GeoService().setId("snapshot-geoserver-proxied").setProtocol(GeoServiceProtocol.WMS).setTitle("Test GeoServer (proxied)").setUrl("https://snapshot.tailormap.nl/geoserver/wms").setAuthorizationRules(rule).setSettings(new GeoServiceSettings().useProxy(true)), new GeoService().setId("openbasiskaart").setProtocol(GeoServiceProtocol.WMTS).setTitle("Openbasiskaart").setUrl("https://www.openbasiskaart.nl/mapcache/wmts").setAuthorizationRules(rule).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution(osmAttribution)).layerSettings(Map.of("osm", new GeoServiceLayerSettings().title("Openbasiskaart").hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERSHOWNEXTZOOMLEVEL).hiDpiSubstituteLayer("osm-hq")))), new GeoService().setId("openbasiskaart-proxied").setProtocol(GeoServiceProtocol.WMTS).setTitle("Openbasiskaart (proxied)").setUrl("https://www.openbasiskaart.nl/mapcache/wmts").setAuthorizationRules(rule).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("test").password("test")).setSettings(new GeoServiceSettings().useProxy(true).defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution(osmAttribution)).layerSettings(Map.of("osm", new GeoServiceLayerSettings().hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERSHOWNEXTZOOMLEVEL).hiDpiSubstituteLayer("osm-hq")))), new GeoService().setId("openbasiskaart-tms").setProtocol(GeoServiceProtocol.XYZ).setTitle("Openbasiskaart (TMS)").setUrl("https://openbasiskaart.nl/mapcache/tms/1.0.0/osm@rd/{z}/{x}/{-y}.png").setAuthorizationRules(rule).setSettings(new GeoServiceSettings().xyzCrs("EPSG:28992").defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution(osmAttribution)).layerSettings(Map.of("xyz", new GeoServiceLayerSettings().maxZoom(15).tileGridExtent(rdTileGridExtent).hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERTILEPIXELRATIOONLY).hiDpiSubstituteLayer("https://openbasiskaart.nl/mapcache/tms/1.0.0/osm-hq@rd-hq/{z}/{x}/{-y}.png")))), new GeoService().setId("pdok-hwh-luchtfotorgb").setProtocol(GeoServiceProtocol.WMTS).setTitle("PDOK HWH luchtfoto").setUrl("https://service.pdok.nl/hwh/luchtfotorgb/wmts/v1_0").setAuthorizationRules(rule).setPublished(true).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution("&copy; <a href=\"https://beeldmateriaal.nl/\">Beeldmateriaal.nl</a>").hiDpiDisabled(false)).putLayerSettingsItem("Actueel_orthoHR", new GeoServiceLayerSettings().title("Luchtfoto"))), new GeoService().setId("b3p-mapproxy-luchtfoto").setProtocol(GeoServiceProtocol.XYZ).setTitle("Luchtfoto (TMS)").setUrl("https://mapproxy.b3p.nl/tms/1.0.0/luchtfoto/EPSG28992/{z}/{x}/{-y}.jpeg").setAuthorizationRules(rule).setPublished(true).setSettings(new GeoServiceSettings().xyzCrs("EPSG:28992").defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution("&copy; <a href=\"https://beeldmateriaal.nl/\">Beeldmateriaal.nl</a>").hiDpiDisabled(false)).layerSettings(Map.of("xyz", new GeoServiceLayerSettings().maxZoom(14).tileGridExtent(rdTileGridExtent).hiDpiMode(TileLayerHiDpiMode.SHOWNEXTZOOMLEVEL)))), new GeoService().setId("at-basemap").setProtocol(GeoServiceProtocol.WMTS).setTitle("basemap.at").setUrl("https://basemap.at/wmts/1.0.0/WMTSCapabilities.xml").setAuthorizationRules(rule).setPublished(true).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution("&copy; <a href=\"https://basemap.at/\">basemap.at</a>").hiDpiDisabled(true)).layerSettings(Map.of("geolandbasemap", new GeoServiceLayerSettings().title("Basemap").hiDpiDisabled(false).hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERTILEPIXELRATIOONLY).hiDpiSubstituteLayer("bmaphidpi"), "bmaporthofoto30cm", new GeoServiceLayerSettings().title("Orthophoto").hiDpiDisabled(false)))), new GeoService().setId("pdok-kadaster-bestuurlijkegebieden").setProtocol(GeoServiceProtocol.WMS).setUrl("https://service.pdok.nl/kadaster/bestuurlijkegebieden/wms/v1_0?service=WMS").setAuthorizationRules(rule).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().description("This layer shows an administrative boundary.")).serverType(GeoServiceSettings.ServerTypeEnum.MAPSERVER).useProxy(true)).setPublished(true).setTitle("PDOK Kadaster bestuurlijke gebieden"));
        if (this.map5url != null) {
            GeoServiceLayerSettings osmAttr = new GeoServiceLayerSettings().attribution(osmAttribution);
            GeoServiceLayerSettings map5Attr = new GeoServiceLayerSettings().attribution("Kaarten: <a href=\"https://map5.nl\">Map5.nl</a>, data: " + osmAttribution);
            services = new ArrayList<GeoService>(services);
            services.add(new GeoService().setId("map5").setProtocol(GeoServiceProtocol.WMTS).setTitle("Map5").setUrl(this.map5url).setAuthorizationRules(rule).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().hiDpiDisabled(true)).layerSettings(Map.of("openlufo", new GeoServiceLayerSettings().attribution("&copy; <a href=\"https://beeldmateriaal.nl/\">Beeldmateriaal.nl</a>, " + osmAttribution), "luforoadslabels", osmAttr, "map5topo", map5Attr, "map5topo_gray", map5Attr, "map5topo_simple", map5Attr, "map5topo_simple_gray", map5Attr, "opensimpletopo", osmAttr, "opensimpletopo_gray", osmAttr, "opentopo", osmAttr, "opentopo_gray", osmAttr))));
        }
        for (GeoService geoService2 : services) {
            this.geoServiceHelper.loadServiceCapabilities(geoService2);
            this.geoServiceRepository.save(geoService2);
            catalogNode.addItemsItem(new TailormapObjectRef().kind(TailormapObjectRef.KindEnum.GEO_SERVICE).id(geoService2.getId()));
        }
        CatalogNode wfsFeatureSourceCatalogNode = new CatalogNode().id("wfs_feature_sources").title("WFS feature sources");
        rootCatalogNode.addChildrenItem(wfsFeatureSourceCatalogNode.getId());
        catalog.getNodes().add(wfsFeatureSourceCatalogNode);
        services.stream().filter(s -> s.getProtocol() == GeoServiceProtocol.WMS).forEach(s -> {
            this.geoServiceHelper.findAndSaveRelatedWFS((GeoService)s);
            List<TMFeatureSource> linkedSources = this.featureSourceRepository.findByLinkedServiceId(s.getId());
            for (TMFeatureSource linkedSource : linkedSources) {
                wfsFeatureSourceCatalogNode.addItemsItem(new TailormapObjectRef().kind(TailormapObjectRef.KindEnum.FEATURE_SOURCE).id(linkedSource.getId().toString()));
            }
        });
        String geodataPassword = "980f1c8A-25933b2";
        Map<String, TMFeatureSource> featureSources = Map.of("postgis", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("PostGIS").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.POSTGIS).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "postgis").port(this.connectToSpatialDbsAtLocalhost ? 54322 : 5432).database("geodata").schema("public").additionalProperties(Map.of("connectionOptions", "?ApplicationName=tailormap-api"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "postgis_osm", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("PostGIS OSM").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.POSTGIS).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "postgis").port(this.connectToSpatialDbsAtLocalhost ? 54322 : 5432).database("geodata").schema("osm").additionalProperties(Map.of("connectionOptions", "?ApplicationName=tailormap-api"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "oracle", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("Oracle").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.ORACLE).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "oracle").database("/XEPDB1").schema("GEODATA").additionalProperties(Map.of("connectionOptions", "?oracle.jdbc.J2EE13Compliant=true"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "sqlserver", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("MS SQL Server").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.SQLSERVER).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "sqlserver").database("geodata").schema("dbo").additionalProperties(Map.of("connectionOptions", ";encrypt=false"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "pdok-kadaster-bestuurlijkegebieden", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.WFS).setUrl("https://service.pdok.nl/kadaster/bestuurlijkegebieden/wfs/v1_0?VERSION=2.0.0").setTitle("Bestuurlijke gebieden").setNotes("Overzicht van de bestuurlijke indeling van Nederland in gemeenten en provincies alsmede de rijksgrens. Gegevens zijn afgeleid uit de Basisregistratie Kadaster (BRK)."));
        this.featureSourceRepository.saveAll(featureSources.values());
        new WFSFeatureSourceHelper().loadCapabilities(featureSources.get("pdok-kadaster-bestuurlijkegebieden"));
        this.geoServiceRepository.findById("pdok-kadaster-bestuurlijkegebieden").ifPresent(geoService -> {
            geoService.getSettings().layerSettings(Map.of("Provinciegebied", new GeoServiceLayerSettings().description("The administrative boundary of Dutch Provinces, connected to a WFS.").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("pdok-kadaster-bestuurlijkegebieden")).getId()).featureTypeName("bestuurlijkegebieden:Provinciegebied")).title("Provinciegebied (WFS)")));
            this.geoServiceRepository.save(geoService);
        });
        CatalogNode featureSourceCatalogNode = new CatalogNode().id("feature_sources").title("Test feature sources");
        rootCatalogNode.addChildrenItem(featureSourceCatalogNode.getId());
        catalog.getNodes().add(featureSourceCatalogNode);
        for (TMFeatureSource featureSource : featureSources.values()) {
            featureSourceCatalogNode.addItemsItem(new TailormapObjectRef().kind(TailormapObjectRef.KindEnum.FEATURE_SOURCE).id(featureSource.getId().toString()));
        }
        this.catalogRepository.save(catalog);
        if (this.connectToSpatialDbs) {
            featureSources.values().forEach(fs -> {
                try {
                    if (fs.getProtocol() == TMFeatureSource.Protocol.JDBC) {
                        new JDBCFeatureSourceHelper().loadCapabilities((TMFeatureSource)fs);
                    } else if (fs.getProtocol() == TMFeatureSource.Protocol.WFS) {
                        new WFSFeatureSourceHelper().loadCapabilities((TMFeatureSource)fs);
                    }
                }
                catch (Exception e) {
                    logger.error("Error loading capabilities for feature source {}", (Object)fs.getTitle(), (Object)e);
                }
            });
            services.stream().filter(s -> s.getId().startsWith("snapshot-geoserver")).forEach(s -> s.getSettings().layerSettings(Map.of("postgis:begroeidterreindeel", new GeoServiceLayerSettings().description("This layer shows data from http://www.postgis.net/\n\nhttps://postgis.net/logos/postgis-logo.png").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("postgis")).getId()).featureTypeName("begroeidterreindeel")), "sqlserver:wegdeel", new GeoServiceLayerSettings().attribution("CC BY 4.0 <a href=\"https://www.nationaalgeoregister.nl/geonetwork/srv/api/records/2cb4769c-b56e-48fa-8685-c48f61b9a319\">BGT/Kadaster</a>").description("This layer shows data from [MS SQL Server](https://learn.microsoft.com/en-us/sql/relational-databases/spatial/spatial-data-sql-server).\n\nhttps://social.technet.microsoft.com/wiki/cfs-filesystemfile.ashx/__key/communityserver-components-imagefileviewer/communityserver-wikis-components-files-00-00-00-00-05/1884.SQL_5F00_h_5F00_rgb.png_2D00_550x0.png").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("sqlserver")).getId()).featureTypeName("wegdeel")), "oracle:WATERDEEL", new GeoServiceLayerSettings().description("This layer shows data from Oracle Spatial.").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("oracle")).getId()).featureTypeName("WATERDEEL")), "postgis:osm_polygon", new GeoServiceLayerSettings().description("This layer shows OSM data from postgis.").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("postgis_osm")).getId()).featureTypeName("osm_polygon")))));
        }
        featureSources.get("pdok-kadaster-bestuurlijkegebieden").getFeatureTypes().stream().filter(ft -> ft.getName().equals("bestuurlijkegebieden:Provinciegebied")).findFirst().ifPresent(ft -> {
            ft.getSettings().addHideAttributesItem("identificatie");
            ft.getSettings().addHideAttributesItem("ligtInLandCode");
            ft.getSettings().addHideAttributesItem("ligtInLandNaam");
            ft.getSettings().addHideAttributesItem("fuuid");
            ft.getSettings().putAttributeSettingsItem("naam", new AttributeSettings().title("Naam"));
        });
        featureSources.get("postgis").getFeatureTypes().stream().filter(ft -> ft.getName().equals("begroeidterreindeel")).findFirst().ifPresent(ft -> {
            ft.getSettings().addHideAttributesItem("terminationdate");
            ft.getSettings().addHideAttributesItem("geom_kruinlijn");
            ft.getSettings().putAttributeSettingsItem("gmlid", new AttributeSettings().title("GML ID"));
            ft.getSettings().putAttributeSettingsItem("identificatie", new AttributeSettings().title("Identificatie"));
            ft.getSettings().putAttributeSettingsItem("tijdstipregistratie", new AttributeSettings().title("Registratie"));
            ft.getSettings().putAttributeSettingsItem("eindregistratie", new AttributeSettings().title("Eind registratie"));
            ft.getSettings().putAttributeSettingsItem("class", new AttributeSettings().title("Klasse"));
            ft.getSettings().putAttributeSettingsItem("bronhouder", new AttributeSettings().title("Bronhouder"));
            ft.getSettings().putAttributeSettingsItem("inonderzoek", new AttributeSettings().title("In onderzoek"));
            ft.getSettings().putAttributeSettingsItem("relatievehoogteligging", new AttributeSettings().title("Relatieve hoogteligging"));
            ft.getSettings().putAttributeSettingsItem("bgt_status", new AttributeSettings().title("BGT status"));
            ft.getSettings().putAttributeSettingsItem("plus_status", new AttributeSettings().title("Plus-status"));
            ft.getSettings().putAttributeSettingsItem("plus_fysiekvoorkomen", new AttributeSettings().title("Plus-fysiek voorkomen"));
            ft.getSettings().putAttributeSettingsItem("begroeidterreindeeloptalud", new AttributeSettings().title("Op talud"));
            ft.getSettings().addAttributeOrderItem("identificatie");
            ft.getSettings().addAttributeOrderItem("bronhouder");
            ft.getSettings().addAttributeOrderItem("class");
        });
        List<AppTreeLayerNode> baseNodes = List.of(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart:osm").serviceId("openbasiskaart").layerName("osm").visible(true), new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR").serviceId("pdok-hwh-luchtfotorgb").layerName("Actueel_orthoHR").visible(false));
        Application app = new Application().setName("default").setTitle("Tailormap demo").setCrs("EPSG:28992").setAuthorizationRules(rule).setComponents(List.of(new Component().type("EDIT").config(new ComponentConfig().enabled(true)))).setContentRoot(new AppContent().addBaseLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(true).title("Base layers").childrenIds(List.of("lyr:openbasiskaart:osm", "lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR", "lyr:openbasiskaart-proxied:osm", "lyr:openbasiskaart-tms:xyz", "lyr:b3p-mapproxy-luchtfoto:xyz"))).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart-proxied:osm").serviceId("openbasiskaart-proxied").layerName("osm").visible(false)).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart-tms:xyz").serviceId("openbasiskaart-tms").layerName("xyz").visible(false)).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:b3p-mapproxy-luchtfoto:xyz").serviceId("b3p-mapproxy-luchtfoto").layerName("xyz").visible(false)).addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root").root(true).title("Layers").childrenIds(List.of("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied", "lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied", "lyr:snapshot-geoserver:postgis:begroeidterreindeel", "lyr:snapshot-geoserver:sqlserver:wegdeel", "lyr:snapshot-geoserver:oracle:WATERDEEL", "lyr:snapshot-geoserver:BGT", "lvl:proxied", "lvl:osm"))).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Provinciegebied").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Gemeentegebied").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:postgis:begroeidterreindeel").serviceId("snapshot-geoserver").layerName("postgis:begroeidterreindeel").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:sqlserver:wegdeel").serviceId("snapshot-geoserver").layerName("sqlserver:wegdeel").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:oracle:WATERDEEL").serviceId("snapshot-geoserver").layerName("oracle:WATERDEEL").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:BGT").serviceId("snapshot-geoserver").layerName("BGT").visible(false)).addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:proxied").title("Proxied").childrenIds(List.of("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel"))).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel").serviceId("snapshot-geoserver-proxied").layerName("postgis:begroeidterreindeel").visible(false)).addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:osm").title("OSM").childrenIds(List.of("lyr:snapshot-geoserver:postgis:osm_polygon"))).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:postgis:osm_polygon").serviceId("snapshot-geoserver").layerName("postgis:osm_polygon").visible(false))).setSettings(new AppSettings().putLayerSettingsItem("lyr:openbasiskaart:osm", new AppLayerSettings().title("Openbasiskaart")).putLayerSettingsItem("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR", new AppLayerSettings().title("Luchtfoto")).putLayerSettingsItem("lyr:openbasiskaart-proxied:osm", new AppLayerSettings().title("Openbasiskaart (proxied)")).putLayerSettingsItem("lyr:snapshot-geoserver:oracle:WATERDEEL", new AppLayerSettings().opacity(50).title("Waterdeel overridden title").editable(true).description("This is the layer description from the app layer setting.").attribution("CC BY 4.0 <a href=\"https://www.nationaalgeoregister.nl/geonetwork/srv/api/records/2cb4769c-b56e-48fa-8685-c48f61b9a319\">BGT/Kadaster</a>")).putLayerSettingsItem("lyr:snapshot-geoserver:postgis:osm_polygon", new AppLayerSettings().description("OpenStreetMap polygon data in EPSG:3857").opacity(60).editable(true).title("OSM Polygon (EPSG:3857)").attribution("\u00a9 <a href=\"https://www.openstreetmap.org/copyright/\">OpenStreetMap</a> contributors")).putLayerSettingsItem("lyr:snapshot-geoserver:postgis:begroeidterreindeel", new AppLayerSettings().editable(true).addHideAttributesItem("begroeidterreindeeloptalud").addReadOnlyAttributesItem("eindregistratie")).putLayerSettingsItem("lyr:snapshot-geoserver:sqlserver:wegdeel", new AppLayerSettings().editable(true)).putLayerSettingsItem("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel", new AppLayerSettings().editable(false)));
        app.getContentRoot().getBaseLayerNodes().addAll(baseNodes);
        app.setInitialExtent(new Bounds().minx(130011.0).miny(458031.0).maxx(132703.0).maxy(459995.0));
        app.setMaxExtent(new Bounds().minx(-285401.0).miny(22598.0).maxx(595401.0).maxy(903401.0));
        if (this.map5url != null) {
            AppTreeLevelNode root = (AppTreeLevelNode)app.getContentRoot().getBaseLayerNodes().get(0);
            ArrayList<String> childrenIds = new ArrayList<String>(root.getChildrenIds());
            childrenIds.add("lyr:map5:map5topo_simple");
            childrenIds.add("lvl:luchtfoto-labels");
            root.setChildrenIds(childrenIds);
            app.getSettings().putLayerSettingsItem("lyr:map5:map5topo_simple", new AppLayerSettings().title("Map5"));
            app.getContentRoot().addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:map5:map5topo_simple").serviceId("map5").layerName("map5topo_simple").visible(false)).addBaseLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:luchtfoto-labels").title("Luchtfoto met labels").addChildrenIdsItem("lyr:map5:luforoadslabels").addChildrenIdsItem("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR2")).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:map5:luforoadslabels").serviceId("map5").layerName("luforoadslabels").visible(false)).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR2").serviceId("pdok-hwh-luchtfotorgb").layerName("Actueel_orthoHR").visible(false));
        }
        this.applicationRepository.save(app);
        app = new Application().setName("base").setTitle("Service base app").setCrs("EPSG:28992").setAuthorizationRules(rule).setContentRoot(new AppContent().addBaseLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(true).title("Base layers").childrenIds(List.of("lyr:openbasiskaart:osm", "lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR"))));
        app.getContentRoot().getBaseLayerNodes().addAll(baseNodes);
        this.applicationRepository.save(app);
        app = new Application().setName("secured").setTitle("secured app").setCrs("EPSG:28992").setAuthorizationRules(ruleLoggedIn).setContentRoot(new AppContent().addBaseLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(true).title("Base layers").childrenIds(List.of("lyr:openbasiskaart:osm", "lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR", "lyr:openbasiskaart-proxied:osm"))).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart-proxied:osm").serviceId("openbasiskaart-proxied").layerName("osm").visible(false)).addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root").root(true).title("Layers").childrenIds(List.of("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied", "lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied", "lvl:proxied"))).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Gemeentegebied").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Provinciegebied").visible(false)).addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:proxied").title("Proxied").childrenIds(List.of("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel"))).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel").serviceId("snapshot-geoserver-proxied").layerName("postgis:begroeidterreindeel").visible(false))).setSettings(new AppSettings().putLayerSettingsItem("lyr:openbasiskaart-proxied:osm", new AppLayerSettings().title("Openbasiskaart (proxied)")));
        app.getContentRoot().getBaseLayerNodes().addAll(baseNodes);
        this.applicationRepository.save(app);
        app = new Application().setName("secured-auth").setTitle("secured (with authorizations)").setCrs("EPSG:28992").setAuthorizationRules(List.of(new AuthorizationRule().groupName("test-foo").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)), new AuthorizationRule().groupName("test-bar").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)))).setContentRoot(new AppContent().addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root").root(true).title("Layers").childrenIds(List.of("lyr:needs-auth", "lyr:public"))).addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:public").title("Public").childrenIds(List.of("lyr:snapshot-geoserver:BGT"))).addLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:needs-auth").title("Needs auth").childrenIds(List.of("lyr:filtered-snapshot-geoserver:BGT", "lyr:filtered-snapshot-geoserver:postgis:begroeidterreindeel"))).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:filtered-snapshot-geoserver:BGT").serviceId("filtered-snapshot-geoserver").layerName("BGT").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:filtered-snapshot-geoserver:postgis:begroeidterreindeel").serviceId("filtered-snapshot-geoserver").layerName("postgis:begroeidterreindeel").visible(true)).addLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:BGT").serviceId("snapshot-geoserver").layerName("BGT").visible(true)));
        this.applicationRepository.save(app);
        app = new Application().setName("austria").setCrs("EPSG:3857").setAuthorizationRules(rule).setTitle("Austria").setInitialExtent(new Bounds().minx(987982.0).miny(5799551.0).maxx(1963423.0).maxy(6320708.0)).setMaxExtent(new Bounds().minx(206516.0).miny(5095461.0).maxx(3146930.0).maxy(7096232.0)).setContentRoot(new AppContent().addBaseLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(true).title("Base layers").childrenIds(List.of("lyr:at-basemap:geolandbasemap", "lyr:at-basemap:orthofoto", "lvl:orthofoto-labels", "lyr:osm:xyz"))).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:geolandbasemap").serviceId("at-basemap").layerName("geolandbasemap").visible(true)).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:orthofoto").serviceId("at-basemap").layerName("bmaporthofoto30cm").visible(false)).addBaseLayerNodesItem(new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:orthofoto-labels").title("Orthophoto with labels").childrenIds(List.of("lyr:at-basemap:bmapoverlay", "lyr:at-basemap:orthofoto_2"))).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:bmapoverlay").serviceId("at-basemap").layerName("bmapoverlay").visible(false)).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:orthofoto_2").serviceId("at-basemap").layerName("bmaporthofoto30cm").visible(false)).addBaseLayerNodesItem(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:osm:xyz").serviceId("osm").layerName("xyz").visible(false)));
        this.applicationRepository.save(app);
        nl.b3p.tailormap.api.persistence.Configuration config = new nl.b3p.tailormap.api.persistence.Configuration();
        config.setKey("default-app");
        config.setValue("default");
        this.configurationRepository.save(config);
        config = new nl.b3p.tailormap.api.persistence.Configuration();
        config.setKey("default-base-app");
        config.setValue("base");
        this.configurationRepository.save(config);
        config = new nl.b3p.tailormap.api.persistence.Configuration();
        config.setKey("test");
        config.setAvailableForViewer(true);
        config.setValue("test value");
        config.setJsonValue(new ObjectMapper().readTree("{ \"someProperty\": 1, \"nestedObject\": { \"num\": 42 } }"));
        this.configurationRepository.save(config);
        logger.info("Test entities created");
    }
}

