/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import nl.b3p.tailormap.api.persistence.json.Bounds;

public class TMFeatureTypeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    private Set<String> keywords;
    private String description;
    private URI publisher;
    private URI schema;
    private URI source;
    private Bounds bounds;
    private String crs;
    private Bounds wgs84BoundingBox;
    private String defaultSrs;
    @Valid
    private Set<String> otherSrs;
    @Valid
    private Set<String> outputFormats;
    private String abstractText;

    public TMFeatureTypeInfo keywords(Set<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public TMFeatureTypeInfo addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new LinkedHashSet<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    @Schema(name="keywords", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="keywords")
    public Set<String> getKeywords() {
        return this.keywords;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public TMFeatureTypeInfo description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TMFeatureTypeInfo publisher(URI publisher) {
        this.publisher = publisher;
        return this;
    }

    @Valid
    @Schema(name="publisher", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="publisher")
    public URI getPublisher() {
        return this.publisher;
    }

    public void setPublisher(URI publisher) {
        this.publisher = publisher;
    }

    public TMFeatureTypeInfo schema(URI schema) {
        this.schema = schema;
        return this;
    }

    @Valid
    @Schema(name="schema", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="schema")
    public URI getSchema() {
        return this.schema;
    }

    public void setSchema(URI schema) {
        this.schema = schema;
    }

    public TMFeatureTypeInfo source(URI source) {
        this.source = source;
        return this;
    }

    @Valid
    @Schema(name="source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="source")
    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public TMFeatureTypeInfo bounds(Bounds bounds) {
        this.bounds = bounds;
        return this;
    }

    @Valid
    @Schema(name="bounds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="bounds")
    public Bounds getBounds() {
        return this.bounds;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public TMFeatureTypeInfo crs(String crs) {
        this.crs = crs;
        return this;
    }

    @Schema(name="crs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="crs")
    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public TMFeatureTypeInfo wgs84BoundingBox(Bounds wgs84BoundingBox) {
        this.wgs84BoundingBox = wgs84BoundingBox;
        return this;
    }

    @Valid
    @Schema(name="wgs84BoundingBox", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="wgs84BoundingBox")
    public Bounds getWgs84BoundingBox() {
        return this.wgs84BoundingBox;
    }

    public void setWgs84BoundingBox(Bounds wgs84BoundingBox) {
        this.wgs84BoundingBox = wgs84BoundingBox;
    }

    public TMFeatureTypeInfo defaultSrs(String defaultSrs) {
        this.defaultSrs = defaultSrs;
        return this;
    }

    @Schema(name="defaultSrs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="defaultSrs")
    public String getDefaultSrs() {
        return this.defaultSrs;
    }

    public void setDefaultSrs(String defaultSrs) {
        this.defaultSrs = defaultSrs;
    }

    public TMFeatureTypeInfo otherSrs(Set<String> otherSrs) {
        this.otherSrs = otherSrs;
        return this;
    }

    public TMFeatureTypeInfo addOtherSrsItem(String otherSrsItem) {
        if (this.otherSrs == null) {
            this.otherSrs = new LinkedHashSet<String>();
        }
        this.otherSrs.add(otherSrsItem);
        return this;
    }

    @Schema(name="otherSrs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="otherSrs")
    public Set<String> getOtherSrs() {
        return this.otherSrs;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setOtherSrs(Set<String> otherSrs) {
        this.otherSrs = otherSrs;
    }

    public TMFeatureTypeInfo outputFormats(Set<String> outputFormats) {
        this.outputFormats = outputFormats;
        return this;
    }

    public TMFeatureTypeInfo addOutputFormatsItem(String outputFormatsItem) {
        if (this.outputFormats == null) {
            this.outputFormats = new LinkedHashSet<String>();
        }
        this.outputFormats.add(outputFormatsItem);
        return this;
    }

    @Schema(name="outputFormats", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="outputFormats")
    public Set<String> getOutputFormats() {
        return this.outputFormats;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setOutputFormats(Set<String> outputFormats) {
        this.outputFormats = outputFormats;
    }

    public TMFeatureTypeInfo abstractText(String abstractText) {
        this.abstractText = abstractText;
        return this;
    }

    @Schema(name="abstractText", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="abstractText")
    public String getAbstractText() {
        return this.abstractText;
    }

    public void setAbstractText(String abstractText) {
        this.abstractText = abstractText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TMFeatureTypeInfo tmFeatureTypeInfo = (TMFeatureTypeInfo)o;
        return Objects.equals(this.keywords, tmFeatureTypeInfo.keywords) && Objects.equals(this.description, tmFeatureTypeInfo.description) && Objects.equals(this.publisher, tmFeatureTypeInfo.publisher) && Objects.equals(this.schema, tmFeatureTypeInfo.schema) && Objects.equals(this.source, tmFeatureTypeInfo.source) && Objects.equals(this.bounds, tmFeatureTypeInfo.bounds) && Objects.equals(this.crs, tmFeatureTypeInfo.crs) && Objects.equals(this.wgs84BoundingBox, tmFeatureTypeInfo.wgs84BoundingBox) && Objects.equals(this.defaultSrs, tmFeatureTypeInfo.defaultSrs) && Objects.equals(this.otherSrs, tmFeatureTypeInfo.otherSrs) && Objects.equals(this.outputFormats, tmFeatureTypeInfo.outputFormats) && Objects.equals(this.abstractText, tmFeatureTypeInfo.abstractText);
    }

    public int hashCode() {
        return Objects.hash(this.keywords, this.description, this.publisher, this.schema, this.source, this.bounds, this.crs, this.wgs84BoundingBox, this.defaultSrs, this.otherSrs, this.outputFormats, this.abstractText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TMFeatureTypeInfo {\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    publisher: ").append(this.toIndentedString(this.publisher)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    wgs84BoundingBox: ").append(this.toIndentedString(this.wgs84BoundingBox)).append("\n");
        sb.append("    defaultSrs: ").append(this.toIndentedString(this.defaultSrs)).append("\n");
        sb.append("    otherSrs: ").append(this.toIndentedString(this.otherSrs)).append("\n");
        sb.append("    outputFormats: ").append(this.toIndentedString(this.outputFormats)).append("\n");
        sb.append("    abstractText: ").append(this.toIndentedString(this.abstractText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

