/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class TMServiceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    @Valid
    private Set<String> keywords;
    private String description;
    private URI publisher;
    private URI schema;
    private URI source;

    public TMServiceInfo title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TMServiceInfo keywords(Set<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public TMServiceInfo addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new LinkedHashSet<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    @Schema(name="keywords", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="keywords")
    public Set<String> getKeywords() {
        return this.keywords;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public TMServiceInfo description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TMServiceInfo publisher(URI publisher) {
        this.publisher = publisher;
        return this;
    }

    @Valid
    @Schema(name="publisher", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="publisher")
    public URI getPublisher() {
        return this.publisher;
    }

    public void setPublisher(URI publisher) {
        this.publisher = publisher;
    }

    public TMServiceInfo schema(URI schema) {
        this.schema = schema;
        return this;
    }

    @Valid
    @Schema(name="schema", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="schema")
    public URI getSchema() {
        return this.schema;
    }

    public void setSchema(URI schema) {
        this.schema = schema;
    }

    public TMServiceInfo source(URI source) {
        this.source = source;
        return this;
    }

    @Valid
    @Schema(name="source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="source")
    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TMServiceInfo tmServiceInfo = (TMServiceInfo)o;
        return Objects.equals(this.title, tmServiceInfo.title) && Objects.equals(this.keywords, tmServiceInfo.keywords) && Objects.equals(this.description, tmServiceInfo.description) && Objects.equals(this.publisher, tmServiceInfo.publisher) && Objects.equals(this.schema, tmServiceInfo.schema) && Objects.equals(this.source, tmServiceInfo.source);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.keywords, this.description, this.publisher, this.schema, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TMServiceInfo {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    publisher: ").append(this.toIndentedString(this.publisher)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

