/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@Schema(name="UserResponse", description="Information about authentication status and user information")
public class UserResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean isAuthenticated;
    private String username;
    @Valid
    private Set<String> roles;

    public UserResponse isAuthenticated(Boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
        return this;
    }

    @Schema(name="isAuthenticated", description="true if the user is authenticated", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="isAuthenticated")
    public Boolean getIsAuthenticated() {
        return this.isAuthenticated;
    }

    public void setIsAuthenticated(Boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public UserResponse username(String username) {
        this.username = username;
        return this;
    }

    @Schema(name="username", description="username of the authenticated user", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UserResponse roles(Set<String> roles) {
        this.roles = roles;
        return this;
    }

    public UserResponse addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new LinkedHashSet<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Schema(name="roles", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="roles")
    public Set<String> getRoles() {
        return this.roles;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserResponse userResponse = (UserResponse)o;
        return Objects.equals(this.isAuthenticated, userResponse.isAuthenticated) && Objects.equals(this.username, userResponse.username) && Objects.equals(this.roles, userResponse.roles);
    }

    public int hashCode() {
        return Objects.hash(this.isAuthenticated, this.username, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserResponse {\n");
        sb.append("    isAuthenticated: ").append(this.toIndentedString(this.isAuthenticated)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

