/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Set;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.Form;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.helper.TMAttributeTypeHelper;
import nl.b3p.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.persistence.json.TMAttributeDescriptor;
import nl.b3p.tailormap.api.persistence.json.TMAttributeType;
import nl.b3p.tailormap.api.persistence.json.TMGeometryType;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.repository.FormRepository;
import nl.b3p.tailormap.api.viewer.model.Attribute;
import nl.b3p.tailormap.api.viewer.model.LayerDetails;
import nl.b3p.tailormap.api.viewer.model.LayerDetailsForm;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@Validated
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/describe"}, produces={"application/json"})
public class LayerDescriptionController {
    private final FeatureSourceRepository featureSourceRepository;
    private final FormRepository formRepository;

    public LayerDescriptionController(FeatureSourceRepository featureSourceRepository, FormRepository formRepository) {
        this.featureSourceRepository = featureSourceRepository;
        this.formRepository = formRepository;
    }

    @Transactional
    @GetMapping
    @Timed(value="get_layer_description", description="Get layer description")
    public ResponseEntity<Serializable> getAppLayerDescription(@ModelAttribute Application application, @ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer) {
        Form form;
        if (layer == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Can't find layer " + appTreeLayerNode);
        }
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        if (tmft == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Layer does not have feature type");
        }
        LayerDetails r = new LayerDetails().id(appTreeLayerNode.getId()).serviceId(appTreeLayerNode.getServiceId()).featureTypeName(tmft.getName()).geometryAttribute(tmft.getDefaultGeometryAttribute()).geometryAttributeIndex(null).geometryType((TMGeometryType)tmft.getDefaultGeometryDescriptor().map(TMAttributeDescriptor::getType).map(TMAttributeType::getValue).map(TMGeometryType::fromValue).orElse(null)).editable(Boolean.valueOf(TMFeatureTypeHelper.isEditable((Application)application, (AppTreeLayerNode)appTreeLayerNode, (TMFeatureType)tmft)));
        AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
        if (appLayerSettings.getFormId() != null && (form = (Form)this.formRepository.findById((Object)appLayerSettings.getFormId()).orElse(null)) != null) {
            r.setForm(new LayerDetailsForm().options(form.getOptions()).fields(form.getFields()));
        }
        Set readOnlyAttributes = TMFeatureTypeHelper.getReadOnlyAttributes((TMFeatureType)tmft, (AppLayerSettings)appLayerSettings);
        TMFeatureTypeHelper.getConfiguredAttributes((TMFeatureType)tmft, (AppLayerSettings)appLayerSettings).values().stream().map(pair -> {
            TMAttributeDescriptor a = (TMAttributeDescriptor)pair.getLeft();
            return new Attribute().featureType(tmft.getId()).key(a.getName()).type(TMAttributeTypeHelper.isGeometry((TMAttributeType)a.getType()) ? TMAttributeType.GEOMETRY : a.getType()).editable(Boolean.valueOf(!a.getName().equals(tmft.getPrimaryKeyAttribute()) && !readOnlyAttributes.contains(a.getName()))).defaultValue(a.getDefaultValue()).nullable(a.getNullable());
        }).forEach(arg_0 -> ((LayerDetails)r).addAttributesItem(arg_0));
        return ResponseEntity.ok((Object)r);
    }
}

