/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import java.io.Serializable;
import java.util.stream.Collectors;
import nl.b3p.tailormap.api.security.OIDCRepository;
import nl.b3p.tailormap.api.viewer.model.LoginConfiguration;
import nl.b3p.tailormap.api.viewer.model.LoginConfigurationSsoLinksInner;
import nl.b3p.tailormap.api.viewer.model.UserResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    private final OIDCRepository oidcRepository;

    public UserController(OIDCRepository oidcRepository) {
        this.oidcRepository = oidcRepository;
    }

    @GetMapping(path={"${tailormap-api.base-path}/user"}, produces={"application/json"})
    public ResponseEntity<Serializable> getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean isAuthenticated = authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
        UserResponse userResponse = new UserResponse().isAuthenticated(Boolean.valueOf(isAuthenticated));
        if (isAuthenticated) {
            userResponse.username(authentication.getName());
            userResponse.setRoles(authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)userResponse);
    }

    @GetMapping(path={"${tailormap-api.base-path}/login/configuration"}, produces={"application/json"})
    public ResponseEntity<LoginConfiguration> getSSOEndpoints() {
        LoginConfiguration result = new LoginConfiguration();
        for (ClientRegistration reg : this.oidcRepository) {
            OIDCRepository.OIDCRegistrationMetadata metadata = this.oidcRepository.getMetadataForRegistrationId(reg.getRegistrationId());
            result.addSsoLinksItem(new LoginConfigurationSsoLinksInner().name(reg.getClientName()).url("/api/oauth2/authorization/" + reg.getRegistrationId()).showForViewer(Boolean.valueOf(metadata.getShowForViewer())));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)result);
    }
}

