/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AttributeSettings;

public class FeatureTypeSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    private List<String> attributeOrder = new ArrayList();
    @Valid
    private List<String> hideAttributes = new ArrayList();
    @Valid
    private List<String> readOnlyAttributes = new ArrayList();
    @Valid
    private Map<String, AttributeSettings> attributeSettings = new HashMap();

    public FeatureTypeSettings attributeOrder(List<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
        return this;
    }

    public FeatureTypeSettings addAttributeOrderItem(String attributeOrderItem) {
        if (this.attributeOrder == null) {
            this.attributeOrder = new ArrayList();
        }
        this.attributeOrder.add(attributeOrderItem);
        return this;
    }

    @NotNull
    @Schema(name="attributeOrder", description="Reordering of the attributes by attribute names. Attributes in the feature type that are not in this array should still be shown; either after the attribute that precedes the attribute in the original feature type attribute ordering or at the end.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attributeOrder")
    public List<String> getAttributeOrder() {
        return this.attributeOrder;
    }

    public void setAttributeOrder(List<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
    }

    public FeatureTypeSettings hideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
        return this;
    }

    public FeatureTypeSettings addHideAttributesItem(String hideAttributesItem) {
        if (this.hideAttributes == null) {
            this.hideAttributes = new ArrayList();
        }
        this.hideAttributes.add(hideAttributesItem);
        return this;
    }

    @NotNull
    @Schema(name="hideAttributes", description="List of attribute names that should be hidden in all viewers.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="hideAttributes")
    public List<String> getHideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
    }

    public FeatureTypeSettings readOnlyAttributes(List<String> readOnlyAttributes) {
        this.readOnlyAttributes = readOnlyAttributes;
        return this;
    }

    public FeatureTypeSettings addReadOnlyAttributesItem(String readOnlyAttributesItem) {
        if (this.readOnlyAttributes == null) {
            this.readOnlyAttributes = new ArrayList();
        }
        this.readOnlyAttributes.add(readOnlyAttributesItem);
        return this;
    }

    @NotNull
    @Schema(name="readOnlyAttributes", description="List of attribute names that are not editable.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="readOnlyAttributes")
    public List<String> getReadOnlyAttributes() {
        return this.readOnlyAttributes;
    }

    public void setReadOnlyAttributes(List<String> readOnlyAttributes) {
        this.readOnlyAttributes = readOnlyAttributes;
    }

    public FeatureTypeSettings attributeSettings(Map<String, AttributeSettings> attributeSettings) {
        this.attributeSettings = attributeSettings;
        return this;
    }

    public FeatureTypeSettings putAttributeSettingsItem(String key, AttributeSettings attributeSettingsItem) {
        if (this.attributeSettings == null) {
            this.attributeSettings = new HashMap();
        }
        this.attributeSettings.put(key, attributeSettingsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="attributeSettings", description="Map of attribute name to its' settings.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attributeSettings")
    public Map<String, AttributeSettings> getAttributeSettings() {
        return this.attributeSettings;
    }

    public void setAttributeSettings(Map<String, AttributeSettings> attributeSettings) {
        this.attributeSettings = attributeSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureTypeSettings featureTypeSettings = (FeatureTypeSettings)o;
        return Objects.equals(this.attributeOrder, featureTypeSettings.attributeOrder) && Objects.equals(this.hideAttributes, featureTypeSettings.hideAttributes) && Objects.equals(this.readOnlyAttributes, featureTypeSettings.readOnlyAttributes) && Objects.equals(this.attributeSettings, featureTypeSettings.attributeSettings);
    }

    public int hashCode() {
        return Objects.hash(this.attributeOrder, this.hideAttributes, this.readOnlyAttributes, this.attributeSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureTypeSettings {\n");
        sb.append("    attributeOrder: ").append(this.toIndentedString((Object)this.attributeOrder)).append("\n");
        sb.append("    hideAttributes: ").append(this.toIndentedString((Object)this.hideAttributes)).append("\n");
        sb.append("    readOnlyAttributes: ").append(this.toIndentedString((Object)this.readOnlyAttributes)).append("\n");
        sb.append("    attributeSettings: ").append(this.toIndentedString((Object)this.attributeSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

