/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.listener;

import ch.rasc.sse.eventbus.SseEvent;
import ch.rasc.sse.eventbus.SseEventBus;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import java.lang.invoke.MethodHandles;
import nl.b3p.tailormap.api.admin.model.EntityEvent;
import nl.b3p.tailormap.api.admin.model.ServerSentEvent;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.rest.webmvc.config.RepositoryRestMvcConfiguration;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class EntityEventPublisher {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    @Lazy
    private EntityManagerFactory entityManagerFactory;
    @Autowired
    @Lazy
    private ObjectMapper objectMapper;
    @Autowired
    @Lazy
    private SseEventBus eventBus;
    @Autowired
    @Lazy
    private RepositoryRestMvcConfiguration repositoryRestMvcConfiguration;

    private void sendEvent(ServerSentEvent.EventTypeEnum eventTypeEnum, Object entity, boolean serializeEntity) {
        Object id = null;
        if (RequestContextHolder.getRequestAttributes() == null) {
            return;
        }
        try {
            id = this.entityManagerFactory.getPersistenceUnitUtil().getIdentifier(entity);
            EntityEvent entityEvent = new EntityEvent().entityName(entity.getClass().getSimpleName()).id(String.valueOf(id));
            if (serializeEntity) {
                entityEvent.setObject((Object)this.repositoryRestMvcConfiguration.objectMapper().valueToTree(entity));
            }
            ServerSentEvent event = new ServerSentEvent().eventType(eventTypeEnum).details((Object)entityEvent);
            this.eventBus.handleEvent(SseEvent.of((String)"message", (Object)this.objectMapper.writeValueAsString((Object)event)));
        }
        catch (Exception e) {
            logger.error("Error sending SSE for event type {}, entity {}, id {}", new Object[]{eventTypeEnum, entity != null ? entity.getClass().getSimpleName() : null, id, e});
        }
    }

    @PostPersist
    public void postPersist(Object entity) {
        if (!(entity instanceof TMFeatureType)) {
            this.sendEvent(ServerSentEvent.EventTypeEnum.ENTITY_CREATED, entity, true);
        }
    }

    @PostRemove
    public void postRemove(Object entity) {
        if (!(entity instanceof TMFeatureType)) {
            this.sendEvent(ServerSentEvent.EventTypeEnum.ENTITY_DELETED, entity, false);
        }
    }

    @PostUpdate
    public void postUpdate(Object entity) {
        this.sendEvent(ServerSentEvent.EventTypeEnum.ENTITY_UPDATED, entity, true);
    }
}

