package nl.b3p.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Node for organizing app layer referencing nodes in a folder tree.
 */

@Schema(name = "AppTreeLevelNode", description = "Node for organizing app layer referencing nodes in a folder tree.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.4.0")
public class AppTreeLevelNode implements Serializable, AppTreeNode {

  private static final long serialVersionUID = 1L;

  private String id;

  private String objectType;

  private String title;

  private String description;

  private Boolean root;

  @Valid
  private List<String> childrenIds = new ArrayList<>();

  public AppTreeLevelNode id(String id) {
    this.id = id;
    return this;
  }

  /**
   * A unique identifier across all tree nodes.
   * @return id
  */
  
  @Schema(name = "id", description = "A unique identifier across all tree nodes.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public AppTreeLevelNode objectType(String objectType) {
    this.objectType = objectType;
    return this;
  }

  /**
   * Get objectType
   * @return objectType
  */
  
  @Schema(name = "objectType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("objectType")
  public String getObjectType() {
    return objectType;
  }

  public void setObjectType(String objectType) {
    this.objectType = objectType;
  }

  public AppTreeLevelNode title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Display title of this tree node.
   * @return title
  */
  @NotNull 
  @Schema(name = "title", description = "Display title of this tree node.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public AppTreeLevelNode description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description for this node entered by application admin.
   * @return description
  */
  
  @Schema(name = "description", description = "Description for this node entered by application admin.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AppTreeLevelNode root(Boolean root) {
    this.root = root;
    return this;
  }

  /**
   * Only a single node in a tree will have this set to true.
   * @return root
  */
  @NotNull 
  @Schema(name = "root", description = "Only a single node in a tree will have this set to true.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("root")
  public Boolean getRoot() {
    return root;
  }

  public void setRoot(Boolean root) {
    this.root = root;
  }

  public AppTreeLevelNode childrenIds(List<String> childrenIds) {
    this.childrenIds = childrenIds;
    return this;
  }

  public AppTreeLevelNode addChildrenIdsItem(String childrenIdsItem) {
    if (this.childrenIds == null) {
      this.childrenIds = new ArrayList<>();
    }
    this.childrenIds.add(childrenIdsItem);
    return this;
  }

  /**
   * Ordered list of ids of LayerTreeNodes that are children of this node.
   * @return childrenIds
  */
  @NotNull 
  @Schema(name = "childrenIds", description = "Ordered list of ids of LayerTreeNodes that are children of this node.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("childrenIds")
  public List<String> getChildrenIds() {
    return childrenIds;
  }

  public void setChildrenIds(List<String> childrenIds) {
    this.childrenIds = childrenIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppTreeLevelNode appTreeLevelNode = (AppTreeLevelNode) o;
    return Objects.equals(this.id, appTreeLevelNode.id) &&
        Objects.equals(this.objectType, appTreeLevelNode.objectType) &&
        Objects.equals(this.title, appTreeLevelNode.title) &&
        Objects.equals(this.description, appTreeLevelNode.description) &&
        Objects.equals(this.root, appTreeLevelNode.root) &&
        Objects.equals(this.childrenIds, appTreeLevelNode.childrenIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, objectType, title, description, root, childrenIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppTreeLevelNode {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    objectType: ").append(toIndentedString(objectType)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    root: ").append(toIndentedString(root)).append("\n");
    sb.append("    childrenIds: ").append(toIndentedString(childrenIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

