package nl.b3p.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import nl.b3p.tailormap.api.persistence.json.TMAttributeType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * presentation metadata for a feature
 */

@Schema(name = "ColumnMetadata", description = "presentation metadata for a feature")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.4.0")
public class ColumnMetadata implements Serializable {

  private static final long serialVersionUID = 1L;

  private String key;

  private String alias = null;

  private TMAttributeType type;

  public ColumnMetadata key(String key) {
    this.key = key;
    return this;
  }

  /**
   * Name of the attribute.
   * @return key
  */
  
  @Schema(name = "key", description = "Name of the attribute.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("key")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ColumnMetadata alias(String alias) {
    this.alias = alias;
    return this;
  }

  /**
   * Get alias
   * @return alias
  */
  
  @Schema(name = "alias", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("alias")
  public String getAlias() {
    return alias;
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }

  public ColumnMetadata type(TMAttributeType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public TMAttributeType getType() {
    return type;
  }

  public void setType(TMAttributeType type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ColumnMetadata columnMetadata = (ColumnMetadata) o;
    return Objects.equals(this.key, columnMetadata.key) &&
        Objects.equals(this.alias, columnMetadata.alias) &&
        Objects.equals(this.type, columnMetadata.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, alias, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ColumnMetadata {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

