package nl.b3p.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import nl.b3p.tailormap.api.viewer.model.ComponentConfig;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * a component to be used in the application
 */

@Schema(name = "Component", description = "a component to be used in the application")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.4.0")
public class Component implements Serializable {

  private static final long serialVersionUID = 1L;

  private String type;

  private ComponentConfig config;

  public Component type(String type) {
    this.type = type;
    return this;
  }

  /**
   * component type eg. featurereport or print
   * @return type
  */
  @NotNull 
  @Schema(name = "type", description = "component type eg. featurereport or print", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Component config(ComponentConfig config) {
    this.config = config;
    return this;
  }

  /**
   * Get config
   * @return config
  */
  @NotNull @Valid 
  @Schema(name = "config", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("config")
  public ComponentConfig getConfig() {
    return config;
  }

  public void setConfig(ComponentConfig config) {
    this.config = config;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Component component = (Component) o;
    return Objects.equals(this.type, component.type) &&
        Objects.equals(this.config, component.config);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, config);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Component {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

