/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.featuresources;

import java.io.IOException;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceHelper;
import nl.b3p.tailormap.api.geotools.featuresources.JDBCFeatureSourceHelper;
import nl.b3p.tailormap.api.geotools.featuresources.WFSFeatureSourceHelper;
import nl.b3p.tailormap.api.persistence.TMFeatureSource;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import org.geotools.api.data.SimpleFeatureSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FeatureSourceFactoryHelper {
    @Value(value="${tailormap-api.timeout}")
    private int timeout;

    public SimpleFeatureSource openGeoToolsFeatureSource(TMFeatureType tmft) throws IOException {
        return this.openGeoToolsFeatureSource(tmft, this.timeout);
    }

    public SimpleFeatureSource openGeoToolsFeatureSource(TMFeatureType tmft, int timeout) throws IOException {
        FeatureSourceHelper sh = this.getHelper(tmft.getFeatureSource());
        return sh.openGeoToolsFeatureSource(tmft, Integer.valueOf(timeout));
    }

    private FeatureSourceHelper getHelper(TMFeatureSource fs) {
        return switch (1.$SwitchMap$nl$b3p$tailormap$api$persistence$TMFeatureSource$Protocol[fs.getProtocol().ordinal()]) {
            case 1 -> new JDBCFeatureSourceHelper();
            case 2 -> new WFSFeatureSourceHelper();
            default -> throw new IllegalArgumentException("Invalid protocol: " + fs.getProtocol());
        };
    }
}

