/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRule;
import nl.b3p.tailormap.api.persistence.json.FeatureTypeRef;
import nl.b3p.tailormap.api.persistence.json.SearchIndexRef;
import nl.b3p.tailormap.api.persistence.json.TileLayerHiDpiMode;

@Schema(name="WMTSLayerSettings", description="Settings applying to a WMTS layer.")
public class WMTSLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Boolean hiDpiDisabled = null;
    private FeatureTypeRef featureType;
    private SearchIndexRef searchIndex;
    private String attribution = null;
    private String description = null;
    @Valid
    private @Valid List<@Valid AuthorizationRule> authorizationRules = new ArrayList();
    private TileLayerHiDpiMode hiDpiMode;
    private String hiDpiSubstituteLayer = null;

    public WMTSLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="Override default title, null if not overridden.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public WMTSLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public WMTSLayerSettings featureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @Valid
    @Schema(name="featureType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public FeatureTypeRef getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public WMTSLayerSettings searchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
        return this;
    }

    @Valid
    @Schema(name="searchIndex", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="searchIndex")
    public SearchIndexRef getSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
    }

    public WMTSLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public WMTSLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WMTSLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public WMTSLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList();
        }
        this.authorizationRules.add(authorizationRulesItem);
        return this;
    }

    @Valid
    @Schema(name="authorizationRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="authorizationRules")
    public @Valid List<@Valid AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public WMTSLayerSettings hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
        return this;
    }

    @Valid
    @Schema(name="hiDpiMode", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiMode")
    public TileLayerHiDpiMode getHiDpiMode() {
        return this.hiDpiMode;
    }

    public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
    }

    public WMTSLayerSettings hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
        return this;
    }

    @Schema(name="hiDpiSubstituteLayer", description="Layer name of this service to substitute when rendering at high dpi.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiSubstituteLayer")
    public String getHiDpiSubstituteLayer() {
        return this.hiDpiSubstituteLayer;
    }

    public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WMTSLayerSettings wmTSLayerSettings = (WMTSLayerSettings)o;
        return Objects.equals(this.title, wmTSLayerSettings.title) && Objects.equals(this.hiDpiDisabled, wmTSLayerSettings.hiDpiDisabled) && Objects.equals(this.featureType, wmTSLayerSettings.featureType) && Objects.equals(this.searchIndex, wmTSLayerSettings.searchIndex) && Objects.equals(this.attribution, wmTSLayerSettings.attribution) && Objects.equals(this.description, wmTSLayerSettings.description) && Objects.equals(this.authorizationRules, wmTSLayerSettings.authorizationRules) && Objects.equals(this.hiDpiMode, wmTSLayerSettings.hiDpiMode) && Objects.equals(this.hiDpiSubstituteLayer, wmTSLayerSettings.hiDpiSubstituteLayer);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hiDpiDisabled, this.featureType, this.searchIndex, this.attribution, this.description, this.authorizationRules, this.hiDpiMode, this.hiDpiSubstituteLayer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WMTSLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString((Object)this.hiDpiDisabled)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString((Object)this.featureType)).append("\n");
        sb.append("    searchIndex: ").append(this.toIndentedString((Object)this.searchIndex)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString((Object)this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    authorizationRules: ").append(this.toIndentedString((Object)this.authorizationRules)).append("\n");
        sb.append("    hiDpiMode: ").append(this.toIndentedString((Object)this.hiDpiMode)).append("\n");
        sb.append("    hiDpiSubstituteLayer: ").append(this.toIndentedString((Object)this.hiDpiSubstituteLayer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

