/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.solr;

import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import nl.b3p.tailormap.api.geotools.processing.GeometryProcessor;
import nl.b3p.tailormap.api.persistence.SearchIndex;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.solr.FeatureIndexingDocument;
import nl.b3p.tailormap.api.util.Constants;
import nl.b3p.tailormap.api.viewer.model.SearchDocument;
import nl.b3p.tailormap.api.viewer.model.SearchResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrHelper
implements AutoCloseable,
Constants {
    private final SolrClient solrClient;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int SOLR_BATCH_SIZE = 1000;
    private static final int SOLR_TIMEOUT = 7000;

    public SolrHelper(@NotNull SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public void addFeatureTypeIndex(@NotNull SearchIndex searchIndex, @NotNull TMFeatureType tmFeatureType, @NotNull FeatureSourceFactoryHelper featureSourceFactoryHelper) throws UnsupportedOperationException, IOException, SolrServerException {
        UpdateResponse updateResponse;
        boolean hasDisplayFields;
        this.createSchemaIfNotExists();
        Instant start = Instant.now();
        if (null == tmFeatureType.getSettings().getSearchFields()) {
            logger.warn("No search fields configured for featuretype: {}", (Object)tmFeatureType.getName());
            throw new UnsupportedOperationException("No search fields configured for featuretype: %s".formatted(tmFeatureType.getName()));
        }
        List<String> searchFields = tmFeatureType.getSettings().getSearchFields().stream().filter(s -> !tmFeatureType.getSettings().getHideAttributes().contains(s)).toList();
        List<String> displayFields = tmFeatureType.getSettings().getSearchDisplayFields().stream().filter(s -> !tmFeatureType.getSettings().getHideAttributes().contains(s)).toList();
        searchIndex.setSearchFieldsUsed(searchFields).setSearchDisplayFieldsUsed(displayFields).setStatus(SearchIndex.Status.INDEXING);
        if (searchFields.isEmpty()) {
            logger.info("No valid search fields configured for featuretype: {}", (Object)tmFeatureType.getName());
            searchIndex.setStatus(SearchIndex.Status.ERROR);
            throw new UnsupportedOperationException("No valid search fields configured for featuretype: %s".formatted(tmFeatureType.getName()));
        }
        HashSet<String> propertyNames = new HashSet<String>();
        propertyNames.add(tmFeatureType.getPrimaryKeyAttribute());
        propertyNames.add(tmFeatureType.getDefaultGeometryAttribute());
        propertyNames.addAll(searchFields);
        boolean bl = hasDisplayFields = !displayFields.isEmpty();
        if (hasDisplayFields) {
            propertyNames.addAll(displayFields);
        }
        this.clearIndexForLayer(searchIndex.getId());
        logger.info("Indexing started for index id: {}, feature type: {}", (Object)searchIndex.getId(), (Object)tmFeatureType.getName());
        SimpleFeatureSource fs = featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
        Query q = new Query(fs.getName().toString());
        tmFeatureType.getSettings().getHideAttributes().forEach(propertyNames::remove);
        q.setPropertyNames(List.copyOf(propertyNames));
        q.setStartIndex(Integer.valueOf(0));
        logger.trace("Indexing query: {}", (Object)q);
        SimpleFeatureCollection simpleFeatureCollection = fs.getFeatures(q);
        int total = simpleFeatureCollection.size();
        ArrayList<FeatureIndexingDocument> docsBatch = new ArrayList<FeatureIndexingDocument>(1000);
        try (SimpleFeatureIterator iterator = simpleFeatureCollection.features();){
            int indexCounter = 0;
            while (iterator.hasNext()) {
                ++indexCounter;
                SimpleFeature feature = (SimpleFeature)iterator.next();
                FeatureIndexingDocument doc = new FeatureIndexingDocument(feature.getID(), searchIndex.getId());
                ArrayList searchValues = new ArrayList();
                ArrayList displayValues = new ArrayList();
                propertyNames.forEach(propertyName -> {
                    Object value = feature.getAttribute(propertyName);
                    if (value != null) {
                        if (value instanceof Geometry) {
                            doc.setGeometry(GeometryProcessor.processGeometry((Object)value, (Boolean)true, (Boolean)true, null));
                        } else {
                            if (searchFields.contains(propertyName)) {
                                searchValues.add(value.toString());
                            }
                            if (hasDisplayFields && displayFields.contains(propertyName)) {
                                displayValues.add(value.toString());
                            }
                        }
                    }
                });
                doc.setSearchFields(searchValues.toArray(new String[searchFields.size() + 2]));
                doc.setDisplayFields(displayValues.toArray(new String[0]));
                docsBatch.add(doc);
                if (indexCounter % 1000 != 0) continue;
                updateResponse = this.solrClient.addBeans(docsBatch);
                logger.info("Added {} documents of {} to index, result status: {}", new Object[]{indexCounter, total, updateResponse.getStatus()});
                docsBatch.clear();
            }
        }
        if (!docsBatch.isEmpty()) {
            updateResponse = this.solrClient.addBeans(docsBatch);
            logger.info("Added last {} documents of {} to index", (Object)docsBatch.size(), (Object)total);
            logger.debug("Update response status: {}", (Object)updateResponse.getStatus());
        }
        Instant end = Instant.now();
        Duration processTime = Duration.between(start, end).abs();
        logger.info("Indexing finished for index id: {}, featuretype: {} at {} in {}", new Object[]{searchIndex.getId(), tmFeatureType.getName(), end, processTime});
        searchIndex.setComment("Indexed %s features in %s.%s seconds, started at %s".formatted(total, processTime.getSeconds(), processTime.getNano(), start));
        searchIndex.setLastIndexed(end.atOffset(ZoneId.systemDefault().getRules().getOffset(end)));
        searchIndex.setStatus(SearchIndex.Status.INDEXED);
        updateResponse = this.solrClient.commit();
        logger.debug("Update response status: {}", (Object)updateResponse.getStatus());
    }

    public void clearIndexForLayer(@NotNull Long searchLayerId) throws IOException, SolrServerException {
        QueryResponse response = this.solrClient.query((SolrParams)new SolrQuery("exists(query(searchLayer:" + searchLayerId + "))"));
        if (response.getResults().getNumFound() > 0L) {
            logger.info("Clearing index for searchLayer {}", (Object)searchLayerId);
            UpdateResponse updateResponse = this.solrClient.deleteByQuery("searchLayer:" + searchLayerId);
            logger.debug("Update response status: {}", (Object)updateResponse.getStatus());
            updateResponse = this.solrClient.commit();
            logger.debug("Update response status: {}", (Object)updateResponse.getStatus());
        } else {
            logger.info("No index to clear for layer {}", (Object)searchLayerId);
        }
    }

    public SearchResponse findInIndex(@NotNull SearchIndex searchIndex, String solrQuery, int start, int numResultsToReturn) throws IOException, SolrServerException, SolrException {
        logger.info("Find in index for {}", (Object)searchIndex.getId());
        if (null == solrQuery || solrQuery.isBlank()) {
            solrQuery = "*";
        }
        SolrQuery query = new SolrQuery("searchFields:" + solrQuery).setShowDebugInfo(logger.isDebugEnabled()).setTimeAllowed(Integer.valueOf(7000)).setIncludeScore(true).setFields(new String[]{"id", "displayFields", "geometry"}).addFilterQuery(new String[]{"searchLayer:" + searchIndex.getId()}).setSort("score", SolrQuery.ORDER.desc).addSort("id", SolrQuery.ORDER.asc).setRows(Integer.valueOf(numResultsToReturn)).setStart(Integer.valueOf(start));
        query.set("q.op", new String[]{"AND"});
        logger.debug("Solr query: {}", (Object)query);
        QueryResponse response = this.solrClient.query((SolrParams)query);
        logger.debug("response: {}", (Object)response);
        SolrDocumentList solrDocumentList = response.getResults();
        logger.debug("Found {} solr documents", (Object)solrDocumentList.getNumFound());
        SearchResponse searchResponse = new SearchResponse().total(Long.valueOf(solrDocumentList.getNumFound())).start(Long.valueOf(response.getResults().getStart())).maxScore(solrDocumentList.getMaxScore());
        response.getResults().forEach(solrDocument -> {
            List<String> displayValues = solrDocument.getFieldValues("displayFields").stream().map(Object::toString).toList();
            searchResponse.addDocumentsItem(new SearchDocument().fid(solrDocument.getFieldValue("id").toString()).geometry(solrDocument.getFieldValue("geometry").toString()).displayValues(displayValues));
        });
        return searchResponse;
    }

    private void createSchemaIfNotExists() throws SolrServerException, IOException {
        SchemaRequest.Field fieldCheck = new SchemaRequest.Field("searchLayer");
        boolean schemaExists = true;
        try {
            SchemaResponse.FieldResponse isField = (SchemaResponse.FieldResponse)fieldCheck.process(this.solrClient);
            logger.debug("Field type {} exists", (Object)isField.getField());
        }
        catch (Exception e) {
            logger.debug(e.getLocalizedMessage());
            logger.info("Field type {} does not exist, creating it", (Object)"searchLayer");
            schemaExists = false;
        }
        if (schemaExists) {
            return;
        }
        logger.info("Creating Solr field type {}", (Object)"searchLayer");
        SchemaRequest.AddField schemaRequest = new SchemaRequest.AddField(Map.of("name", "searchLayer", "type", "string", "indexed", true, "stored", true, "multiValued", false, "required", true, "uninvertible", false));
        schemaRequest.process(this.solrClient);
        logger.info("Creating Solr field type {}", (Object)"geometry");
        SchemaRequest.AddField schemaRequestGeom = new SchemaRequest.AddField(Map.of("name", "geometry", "type", "string", "indexed", false, "stored", true, "multiValued", false));
        schemaRequestGeom.process(this.solrClient);
    }

    @Override
    public void close() throws IOException {
        if (null != this.solrClient) {
            this.solrClient.close();
        }
    }
}

