package nl.b3p.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import nl.b3p.tailormap.api.persistence.json.TMServiceCapsCapabilities;
import nl.b3p.tailormap.api.persistence.json.TMServiceInfo;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * TMServiceCaps
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.6.0")
public class TMServiceCaps implements Serializable {

  private static final long serialVersionUID = 1L;

  private String corsAllowOrigin;

  private TMServiceInfo serviceInfo;

  private TMServiceCapsCapabilities capabilities;

  public TMServiceCaps corsAllowOrigin(String corsAllowOrigin) {
    this.corsAllowOrigin = corsAllowOrigin;
    return this;
  }

  /**
   * Value of the 'Access-Control-Allow-Origin' header from the GetCapabilities request. This may be null when it wasn't returned (no CORS support), '*' when CORS is enabled for all origins, or contain a specific origin (usually when credentials are used).
   * @return corsAllowOrigin
  */
  
  @Schema(name = "corsAllowOrigin", description = "Value of the 'Access-Control-Allow-Origin' header from the GetCapabilities request. This may be null when it wasn't returned (no CORS support), '*' when CORS is enabled for all origins, or contain a specific origin (usually when credentials are used).", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("corsAllowOrigin")
  public String getCorsAllowOrigin() {
    return corsAllowOrigin;
  }

  public void setCorsAllowOrigin(String corsAllowOrigin) {
    this.corsAllowOrigin = corsAllowOrigin;
  }

  public TMServiceCaps serviceInfo(TMServiceInfo serviceInfo) {
    this.serviceInfo = serviceInfo;
    return this;
  }

  /**
   * Get serviceInfo
   * @return serviceInfo
  */
  @Valid 
  @Schema(name = "serviceInfo", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("serviceInfo")
  public TMServiceInfo getServiceInfo() {
    return serviceInfo;
  }

  public void setServiceInfo(TMServiceInfo serviceInfo) {
    this.serviceInfo = serviceInfo;
  }

  public TMServiceCaps capabilities(TMServiceCapsCapabilities capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  /**
   * Get capabilities
   * @return capabilities
  */
  @Valid 
  @Schema(name = "capabilities", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("capabilities")
  public TMServiceCapsCapabilities getCapabilities() {
    return capabilities;
  }

  public void setCapabilities(TMServiceCapsCapabilities capabilities) {
    this.capabilities = capabilities;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TMServiceCaps tmServiceCaps = (TMServiceCaps) o;
    return Objects.equals(this.corsAllowOrigin, tmServiceCaps.corsAllowOrigin) &&
        Objects.equals(this.serviceInfo, tmServiceCaps.serviceInfo) &&
        Objects.equals(this.capabilities, tmServiceCaps.capabilities);
  }

  @Override
  public int hashCode() {
    return Objects.hash(corsAllowOrigin, serviceInfo, capabilities);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TMServiceCaps {\n");
    sb.append("    corsAllowOrigin: ").append(toIndentedString(corsAllowOrigin)).append("\n");
    sb.append("    serviceInfo: ").append(toIndentedString(serviceInfo)).append("\n");
    sb.append("    capabilities: ").append(toIndentedString(capabilities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

