package nl.b3p.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import nl.b3p.tailormap.api.persistence.json.Bounds;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * CRS information
 */

@Schema(name = "TMCoordinateReferenceSystem", description = "CRS information")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.6.0")
public class TMCoordinateReferenceSystem implements Serializable {

  private static final long serialVersionUID = 1L;

  private String code;

  private String definition;

  private Bounds bounds;

  private String unit = null;

  public TMCoordinateReferenceSystem() {
    super();
  }

  public TMCoordinateReferenceSystem code(String code) {
    this.code = code;
    return this;
  }

  /**
   * The CRS identifier
   * @return code
  */
  @NotNull 
  @Schema(name = "code", example = "EPSG:28992", description = "The CRS identifier", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("code")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public TMCoordinateReferenceSystem definition(String definition) {
    this.definition = definition;
    return this;
  }

  /**
   * CRS definition in WKT format
   * @return definition
  */
  @NotNull 
  @Schema(name = "definition", example = "PROJCS[\"Amersfoort / RD New\", GEOGCS[\"Amersfoort\", DATUM[\"Amersfoort\", SPHEROID[\"Bessel 1841\", 6377397.155, 299.1528128, AUTHORITY[\"EPSG\",\"7004\"]], TOWGS84[565.2369, 50.0087, 465.658, -0.40685733032239757, -0.3507326765425626, 1.8703473836067956, 4.0812], AUTHORITY[\"EPSG\",\"6289\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Geodetic latitude\", NORTH], AXIS[\"Geodetic longitude\", EAST], AUTHORITY[\"EPSG\",\"4289\"]], PROJECTION[\"Oblique_Stereographic\", AUTHORITY[\"EPSG\",\"9809\"]], PARAMETER[\"central_meridian\", 5.387638888888891], PARAMETER[\"latitude_of_origin\", 52.15616055555556], PARAMETER[\"scale_factor\", 0.9999079], PARAMETER[\"false_easting\", 155000.0], PARAMETER[\"false_northing\", 463000.0], UNIT[\"m\", 1.0], AXIS[\"Easting\", EAST], AXIS[\"Northing\", NORTH], AUTHORITY[\"EPSG\",\"28992\"]]", description = "CRS definition in WKT format", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("definition")
  public String getDefinition() {
    return definition;
  }

  public void setDefinition(String definition) {
    this.definition = definition;
  }

  public TMCoordinateReferenceSystem bounds(Bounds bounds) {
    this.bounds = bounds;
    return this;
  }

  /**
   * Get bounds
   * @return bounds
  */
  @Valid 
  @Schema(name = "bounds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("bounds")
  public Bounds getBounds() {
    return bounds;
  }

  public void setBounds(Bounds bounds) {
    this.bounds = bounds;
  }

  public TMCoordinateReferenceSystem unit(String unit) {
    this.unit = unit;
    return this;
  }

  /**
   * The unit if all axis use the same unit, null otherwise
   * @return unit
  */
  
  @Schema(name = "unit", example = "m", description = "The unit if all axis use the same unit, null otherwise", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("unit")
  public String getUnit() {
    return unit;
  }

  public void setUnit(String unit) {
    this.unit = unit;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TMCoordinateReferenceSystem tmCoordinateReferenceSystem = (TMCoordinateReferenceSystem) o;
    return Objects.equals(this.code, tmCoordinateReferenceSystem.code) &&
        Objects.equals(this.definition, tmCoordinateReferenceSystem.definition) &&
        Objects.equals(this.bounds, tmCoordinateReferenceSystem.bounds) &&
        Objects.equals(this.unit, tmCoordinateReferenceSystem.unit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, definition, bounds, unit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TMCoordinateReferenceSystem {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    definition: ").append(toIndentedString(definition)).append("\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

