/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import nl.b3p.tailormap.api.persistence.Group;
import nl.b3p.tailormap.api.persistence.User;
import nl.b3p.tailormap.api.persistence.json.AdminAdditionalProperty;
import nl.b3p.tailormap.api.repository.GroupRepository;
import nl.b3p.tailormap.api.repository.UserRepository;
import nl.b3p.tailormap.api.security.OIDCRepository;
import nl.b3p.tailormap.api.viewer.model.AdditionalProperty;
import nl.b3p.tailormap.api.viewer.model.LoginConfiguration;
import nl.b3p.tailormap.api.viewer.model.LoginConfigurationSsoLinksInner;
import nl.b3p.tailormap.api.viewer.model.UserResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    private final OIDCRepository oidcRepository;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;

    public UserController(OIDCRepository oidcRepository, UserRepository userRepository, GroupRepository groupRepository) {
        this.oidcRepository = oidcRepository;
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
    }

    @GetMapping(path={"${tailormap-api.base-path}/user"}, produces={"application/json"})
    public ResponseEntity<Serializable> getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean isAuthenticated = authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
        UserResponse userResponse = new UserResponse().isAuthenticated(isAuthenticated);
        if (isAuthenticated) {
            userResponse.username(authentication.getName());
            userResponse.setRoles(authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
            Function<AdminAdditionalProperty, AdditionalProperty> mapToPublicProperty = ap -> new AdditionalProperty().key(ap.getKey()).value(ap.getValue());
            ((List)this.userRepository.findById(authentication.getName()).map(User::getAdditionalProperties).orElse(new ArrayList())).stream().filter(AdminAdditionalProperty::getIsPublic).map(mapToPublicProperty).forEach(userResponse::addPropertiesItem);
            this.groupRepository.findAllById(userResponse.getRoles()).stream().map(Group::getAdditionalProperties).filter(Objects::nonNull).flatMap(Collection::stream).filter(AdminAdditionalProperty::getIsPublic).map(mapToPublicProperty).forEach(userResponse::addGroupPropertiesItem);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)userResponse);
    }

    @GetMapping(path={"${tailormap-api.base-path}/login/configuration"}, produces={"application/json"})
    public ResponseEntity<LoginConfiguration> getSSOEndpoints() {
        LoginConfiguration result = new LoginConfiguration();
        for (ClientRegistration reg : this.oidcRepository) {
            OIDCRepository.OIDCRegistrationMetadata metadata = this.oidcRepository.getMetadataForRegistrationId(reg.getRegistrationId());
            result.addSsoLinksItem(new LoginConfigurationSsoLinksInner().name(reg.getClientName()).url("/api/oauth2/authorization/" + reg.getRegistrationId()).showForViewer(metadata.getShowForViewer()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)result);
    }
}

