/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.helper;

import jakarta.persistence.EntityManager;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import nl.b3p.tailormap.api.controller.GeoServiceProxyController;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.persistence.helper.GeoServiceHelper;
import nl.b3p.tailormap.api.persistence.helper.GeoToolsHelper;
import nl.b3p.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import nl.b3p.tailormap.api.persistence.json.AppContent;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.AppTreeLevelNode;
import nl.b3p.tailormap.api.persistence.json.AppTreeNode;
import nl.b3p.tailormap.api.persistence.json.Bounds;
import nl.b3p.tailormap.api.persistence.json.GeoServiceDefaultLayerSettings;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayerSettings;
import nl.b3p.tailormap.api.persistence.json.ServicePublishingSettings;
import nl.b3p.tailormap.api.persistence.json.TileLayerHiDpiMode;
import nl.b3p.tailormap.api.repository.ApplicationRepository;
import nl.b3p.tailormap.api.repository.ConfigurationRepository;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.repository.GeoServiceRepository;
import nl.b3p.tailormap.api.security.AuthorizationService;
import nl.b3p.tailormap.api.util.TMStringUtils;
import nl.b3p.tailormap.api.viewer.model.AppLayer;
import nl.b3p.tailormap.api.viewer.model.LayerTreeNode;
import nl.b3p.tailormap.api.viewer.model.MapResponse;
import nl.b3p.tailormap.api.viewer.model.TMCoordinateReferenceSystem;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.referencing.wkt.Formattable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplicationHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_WEB_MERCATOR_CRS = "EPSG:3857";
    private final GeoServiceHelper geoServiceHelper;
    private final GeoServiceRepository geoServiceRepository;
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    private final FeatureSourceRepository featureSourceRepository;
    private final EntityManager entityManager;
    private final AuthorizationService authorizationService;

    public ApplicationHelper(GeoServiceHelper geoServiceHelper, GeoServiceRepository geoServiceRepository, ConfigurationRepository configurationRepository, ApplicationRepository applicationRepository, FeatureSourceRepository featureSourceRepository, EntityManager entityManager, AuthorizationService authorizationService) {
        this.geoServiceHelper = geoServiceHelper;
        this.geoServiceRepository = geoServiceRepository;
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
        this.featureSourceRepository = featureSourceRepository;
        this.entityManager = entityManager;
        this.authorizationService = authorizationService;
    }

    public Application getServiceApplication(String baseAppName, String projection, GeoService service) {
        Application app;
        if (baseAppName == null) {
            baseAppName = Optional.ofNullable(service.getSettings().getPublishing()).map(ServicePublishingSettings::getBaseApp).orElseGet(() -> this.configurationRepository.get("default-base-app"));
        }
        Application baseApp = null;
        if (baseAppName != null && (baseApp = this.applicationRepository.findByName(baseAppName)) != null) {
            this.entityManager.detach((Object)baseApp);
        }
        Application application = app = baseApp != null ? baseApp : new Application().setContentRoot(new AppContent());
        if (projection != null) {
            throw new UnsupportedOperationException("Projection filtering not yet supported");
        }
        projection = baseApp != null ? baseApp.getCrs() : DEFAULT_WEB_MERCATOR_CRS;
        app.setName(service.getId()).setTitle(service.getTitle()).setCrs(projection);
        return app;
    }

    @Transactional
    public MapResponse toMapResponse(Application app) {
        MapResponse mapResponse = new MapResponse();
        this.setCrsAndBounds(app, mapResponse);
        this.setLayers(app, mapResponse);
        return mapResponse;
    }

    public void setCrsAndBounds(Application a, MapResponse mapResponse) {
        CoordinateReferenceSystem gtCrs = a.getGeoToolsCoordinateReferenceSystem();
        if (gtCrs == null) {
            throw new IllegalArgumentException("Invalid CRS: " + a.getCrs());
        }
        TMCoordinateReferenceSystem crs = new TMCoordinateReferenceSystem().code(a.getCrs()).definition(((Formattable)gtCrs).toWKT(0)).bounds(GeoToolsHelper.fromCRS(gtCrs)).unit(Optional.ofNullable(CRSUtilities.getUnit((CoordinateSystem)gtCrs.getCoordinateSystem())).map(Objects::toString).orElse(null));
        Bounds maxExtent = a.getMaxExtent() != null ? a.getMaxExtent() : crs.getBounds();
        Bounds initialExtent = a.getInitialExtent() != null ? a.getInitialExtent() : maxExtent;
        mapResponse.crs(crs).maxExtent(maxExtent).initialExtent(initialExtent);
    }

    public void setLayers(Application app, MapResponse mr) {
        new MapResponseLayerBuilder(app, mr).buildLayers();
    }

    private String getProxyUrl(GeoService geoService, Application application, AppTreeLayerNode appTreeLayerNode) {
        return WebMvcLinkBuilder.linkTo(GeoServiceProxyController.class, Map.of("viewerKind", "app", "viewerName", application.getName(), "appLayerId", appTreeLayerNode.getId(), "protocol", geoService.getProtocol().getValue())).toString();
    }

    private class MapResponseLayerBuilder {
        private final Application app;
        private final MapResponse mr;
        private final Map<GeoServiceLayer, String> serviceLayerServiceIds = new HashMap<GeoServiceLayer, String>();

        public MapResponseLayerBuilder(Application app, MapResponse mr) {
            this.app = app;
            this.mr = mr;
        }

        public void buildLayers() {
            if (this.app.getContentRoot() != null) {
                this.buildBackgroundLayers();
                this.buildOverlayLayers();
            }
        }

        private void buildBackgroundLayers() {
            if (this.app.getContentRoot().getBaseLayerNodes() != null) {
                for (AppTreeNode node : this.app.getContentRoot().getBaseLayerNodes()) {
                    this.addAppTreeNodeItem(node, this.mr.getBaseLayerTreeNodes());
                }
            }
        }

        private void buildOverlayLayers() {
            if (this.app.getContentRoot().getLayerNodes() != null) {
                for (AppTreeNode node : this.app.getContentRoot().getLayerNodes()) {
                    this.addAppTreeNodeItem(node, this.mr.getLayerTreeNodes());
                }
            }
        }

        private void addAppTreeNodeItem(AppTreeNode node, List<LayerTreeNode> layerTreeNodeList) {
            LayerTreeNode layerTreeNode = new LayerTreeNode();
            if ("AppTreeLayerNode".equals(node.getObjectType())) {
                AppTreeLayerNode appTreeLayerNode = (AppTreeLayerNode)node;
                layerTreeNode.setId(appTreeLayerNode.getId());
                layerTreeNode.setAppLayerId(appTreeLayerNode.getId());
                if (!this.addAppLayerItem(appTreeLayerNode)) {
                    return;
                }
                layerTreeNode.setName(appTreeLayerNode.getLayerName());
                layerTreeNode.setDescription(appTreeLayerNode.getDescription());
            } else if ("AppTreeLevelNode".equals(node.getObjectType())) {
                AppTreeLevelNode appTreeLevelNode = (AppTreeLevelNode)node;
                layerTreeNode.setId(appTreeLevelNode.getId());
                layerTreeNode.setChildrenIds(appTreeLevelNode.getChildrenIds());
                layerTreeNode.setRoot(Boolean.TRUE.equals(appTreeLevelNode.getRoot()));
                layerTreeNode.setName(appTreeLevelNode.getTitle());
                layerTreeNode.setDescription(appTreeLevelNode.getDescription());
            }
            layerTreeNodeList.add(layerTreeNode);
        }

        private boolean addAppLayerItem(AppTreeLayerNode layerRef) {
            Triple<GeoService, GeoServiceLayer, GeoServiceLayerSettings> serviceWithLayer = this.findServiceLayer(layerRef);
            GeoService service = (GeoService)serviceWithLayer.getLeft();
            GeoServiceLayer serviceLayer = (GeoServiceLayer)serviceWithLayer.getMiddle();
            if (service == null || serviceLayer == null) {
                return false;
            }
            GeoServiceDefaultLayerSettings defaultLayerSettings = Optional.ofNullable(service.getSettings().getDefaultLayerSettings()).orElseGet(GeoServiceDefaultLayerSettings::new);
            GeoServiceLayerSettings serviceLayerSettings = Optional.ofNullable((GeoServiceLayerSettings)serviceWithLayer.getRight()).orElseGet(GeoServiceLayerSettings::new);
            AppLayerSettings appLayerSettings = this.app.getAppLayerSettings(layerRef);
            String title = Objects.requireNonNullElse(TMStringUtils.nullIfEmpty(appLayerSettings.getTitle()), service.getTitleWithSettingsOverrides(layerRef.getLayerName()));
            String description = (String)ObjectUtils.firstNonNull((Object[])new String[]{TMStringUtils.nullIfEmpty(appLayerSettings.getDescription()), TMStringUtils.nullIfEmpty(serviceLayerSettings.getDescription()), TMStringUtils.nullIfEmpty(defaultLayerSettings.getDescription())});
            String attribution = (String)ObjectUtils.firstNonNull((Object[])new String[]{TMStringUtils.nullIfEmpty(appLayerSettings.getAttribution()), TMStringUtils.nullIfEmpty(serviceLayerSettings.getAttribution()), TMStringUtils.nullIfEmpty(defaultLayerSettings.getAttribution())});
            boolean tilingDisabled = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{serviceLayerSettings.getTilingDisabled(), defaultLayerSettings.getTilingDisabled(), false});
            Integer tilingGutter = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{serviceLayerSettings.getTilingGutter(), defaultLayerSettings.getTilingGutter(), 0});
            boolean hiDpiDisabled = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{serviceLayerSettings.getHiDpiDisabled(), defaultLayerSettings.getHiDpiDisabled(), false});
            TileLayerHiDpiMode hiDpiMode = (TileLayerHiDpiMode)((Object)ObjectUtils.firstNonNull((Object[])new TileLayerHiDpiMode[]{serviceLayerSettings.getHiDpiMode(), defaultLayerSettings.getHiDpiMode(), null}));
            String hiDpiSubstituteLayer = serviceLayerSettings.getHiDpiSubstituteLayer();
            TMFeatureType tmft = service.findFeatureTypeForLayer(serviceLayer, ApplicationHelper.this.featureSourceRepository);
            boolean proxied = service.getSettings().getUseProxy();
            this.mr.addAppLayersItem(new AppLayer().id(layerRef.getId()).serviceId(this.serviceLayerServiceIds.get(serviceLayer)).layerName(layerRef.getLayerName()).hasAttributes(tmft != null).editable(TMFeatureTypeHelper.isEditable(this.app, layerRef, tmft)).url(proxied ? ApplicationHelper.this.getProxyUrl(service, this.app, layerRef) : null).maxScale(serviceLayer.getMaxScale()).minScale(serviceLayer.getMinScale()).title(title).tilingDisabled(tilingDisabled).tilingGutter(tilingGutter).hiDpiDisabled(hiDpiDisabled).hiDpiMode(hiDpiMode).hiDpiSubstituteLayer(hiDpiSubstituteLayer).minZoom(serviceLayerSettings.getMinZoom()).maxZoom(serviceLayerSettings.getMaxZoom()).tileSize(serviceLayerSettings.getTileSize()).tileGridExtent(serviceLayerSettings.getTileGridExtent()).opacity(appLayerSettings.getOpacity()).autoRefreshInSeconds(appLayerSettings.getAutoRefreshInSeconds()).visible(layerRef.getVisible()).attribution(attribution).description(description));
            return true;
        }

        private Triple<GeoService, GeoServiceLayer, GeoServiceLayerSettings> findServiceLayer(AppTreeLayerNode layerRef) {
            GeoService service = ApplicationHelper.this.geoServiceRepository.findById(layerRef.getServiceId()).orElse(null);
            if (service == null) {
                logger.warn("App {} references layer \"{}\" of missing service {}", new Object[]{this.app.getId(), layerRef.getLayerName(), layerRef.getServiceId()});
                return Triple.of(null, null, null);
            }
            if (!ApplicationHelper.this.authorizationService.mayUserRead(service)) {
                return Triple.of(null, null, null);
            }
            GeoServiceLayer serviceLayer = service.findLayer(layerRef.getLayerName());
            if (serviceLayer == null) {
                logger.warn("App {} references layer \"{}\" not found in capabilities of service {}", new Object[]{this.app.getId(), layerRef.getLayerName(), service.getId()});
                return Triple.of(null, null, null);
            }
            if (!ApplicationHelper.this.authorizationService.mayUserRead(service, serviceLayer)) {
                return Triple.of(null, null, null);
            }
            this.serviceLayerServiceIds.put(serviceLayer, service.getId());
            if (this.mr.getServices().stream().filter(s -> s.getId().equals(service.getId())).findAny().isEmpty()) {
                this.mr.addServicesItem(service.toJsonPojo(ApplicationHelper.this.geoServiceHelper));
            }
            GeoServiceLayerSettings layerSettings = service.getLayerSettings(layerRef.getLayerName());
            return Triple.of((Object)service, (Object)serviceLayer, (Object)layerSettings);
        }
    }
}

