/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AppI18nSettings;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppUiSettings;

@Schema(name="AppSettings", description="Settings applying to a viewer application.")
public class AppSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AppI18nSettings i18nSettings;
    private AppUiSettings uiSettings;
    @Valid
    private Map<String, AppLayerSettings> layerSettings = new HashMap<String, AppLayerSettings>();

    public AppSettings i18nSettings(AppI18nSettings i18nSettings) {
        this.i18nSettings = i18nSettings;
        return this;
    }

    @Valid
    @Schema(name="i18nSettings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="i18nSettings")
    public AppI18nSettings getI18nSettings() {
        return this.i18nSettings;
    }

    public void setI18nSettings(AppI18nSettings i18nSettings) {
        this.i18nSettings = i18nSettings;
    }

    public AppSettings uiSettings(AppUiSettings uiSettings) {
        this.uiSettings = uiSettings;
        return this;
    }

    @Valid
    @Schema(name="uiSettings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="uiSettings")
    public AppUiSettings getUiSettings() {
        return this.uiSettings;
    }

    public void setUiSettings(AppUiSettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    public AppSettings layerSettings(Map<String, AppLayerSettings> layerSettings) {
        this.layerSettings = layerSettings;
        return this;
    }

    public AppSettings putLayerSettingsItem(String key, AppLayerSettings layerSettingsItem) {
        if (this.layerSettings == null) {
            this.layerSettings = new HashMap<String, AppLayerSettings>();
        }
        this.layerSettings.put(key, layerSettingsItem);
        return this;
    }

    @Valid
    @Schema(name="layerSettings", description="Map of id of an AppTreeLayerNode to its' settings.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="layerSettings")
    public Map<String, AppLayerSettings> getLayerSettings() {
        return this.layerSettings;
    }

    public void setLayerSettings(Map<String, AppLayerSettings> layerSettings) {
        this.layerSettings = layerSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSettings appSettings = (AppSettings)o;
        return Objects.equals(this.i18nSettings, appSettings.i18nSettings) && Objects.equals(this.uiSettings, appSettings.uiSettings) && Objects.equals(this.layerSettings, appSettings.layerSettings);
    }

    public int hashCode() {
        return Objects.hash(this.i18nSettings, this.uiSettings, this.layerSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppSettings {\n");
        sb.append("    i18nSettings: ").append(this.toIndentedString(this.i18nSettings)).append("\n");
        sb.append("    uiSettings: ").append(this.toIndentedString(this.uiSettings)).append("\n");
        sb.append("    layerSettings: ").append(this.toIndentedString(this.layerSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

