/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.b3p.tailormap.api.persistence.Group;
import nl.b3p.tailormap.api.persistence.User;
import nl.b3p.tailormap.api.repository.GroupRepository;
import nl.b3p.tailormap.api.repository.UserRepository;
import nl.b3p.tailormap.api.security.InternalAdminAuthentication;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ansi.AnsiPropertySource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StreamUtils;

@Configuration
@ConditionalOnProperty(name={"tailormap-api.security.admin.create-if-not-exists"}, havingValue="true")
public class AdminAccountCreator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${tailormap-api.security.admin.username}")
    private String newAdminUsername;
    @Value(value="${tailormap-api.security.admin.hashed-password}")
    private String newAdminHashedPassword;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;
    private final PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();

    public AdminAccountCreator(UserRepository userRepository, GroupRepository groupRepository) {
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    @Transactional
    public void postConstruct() throws IOException {
        logger.trace("Checking whether an admin account exists...");
        InternalAdminAuthentication.setInSecurityContext();
        try {
            if (!this.userRepository.existsByGroupsNameIn(List.of("admin"))) {
                if (StringUtils.isNotBlank((CharSequence)this.newAdminHashedPassword) && this.newAdminHashedPassword.startsWith("{bcrypt}")) {
                    this.createAdmin(this.newAdminUsername, this.newAdminHashedPassword);
                    logger.info("New admin account \"{}\" created with hashed password from environment", (Object)this.newAdminUsername);
                } else {
                    String password = UUID.randomUUID().toString();
                    this.createAdmin(this.newAdminUsername, this.passwordEncoder.encode((CharSequence)password));
                    logger.info(AdminAccountCreator.getAccountBanner(this.newAdminUsername, password));
                }
            }
        }
        finally {
            InternalAdminAuthentication.clearSecurityContextAuthentication();
        }
    }

    private void createAdmin(String username, String hashedPassword) {
        User u = new User().setUsername(username).setPassword(hashedPassword);
        u.getGroups().add((Group)this.groupRepository.getReferenceById("admin"));
        this.userRepository.saveAndFlush(u);
    }

    private static String getAccountBanner(String username, String password) throws IOException {
        String accountBanner = StreamUtils.copyToString((InputStream)new ClassPathResource("account-banner.txt").getInputStream(), (Charset)StandardCharsets.US_ASCII);
        MutablePropertySources sources = new MutablePropertySources();
        sources.addFirst((PropertySource)new AnsiPropertySource("ansi", true));
        sources.addFirst((PropertySource)new MapPropertySource("account", Map.of("username", username, "password", password)));
        return new PropertySourcesPropertyResolver((PropertySources)sources).resolvePlaceholders(accountBanner);
    }
}

