/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuditInterceptor
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication instanceof AnonymousAuthenticationToken) {
                logger.debug("Audit: request by anonymous user ({})", (Object)authentication.getAuthorities());
            }
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                logger.debug("Audit: request by registered user: {}, authorities: {}", (Object)authentication.getName(), (Object)authentication.getAuthorities());
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

