/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRule;
import nl.b3p.tailormap.api.persistence.json.FeatureTypeRef;
import nl.b3p.tailormap.api.persistence.json.SearchIndexRef;

@Schema(name="WMSLayerSettings", description="Settings applying to a WMS layer.")
public class WMSLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Boolean hiDpiDisabled = null;
    private FeatureTypeRef featureType;
    private SearchIndexRef searchIndex;
    private String attribution = null;
    private String description = null;
    private String legendImageId = null;
    @Valid
    private @Valid List<@Valid AuthorizationRule> authorizationRules = new ArrayList();
    private Boolean tilingDisabled = null;
    private Integer tilingGutter = null;

    public WMSLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="Override default title, null if not overridden.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public WMSLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public WMSLayerSettings featureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @Valid
    @Schema(name="featureType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public FeatureTypeRef getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public WMSLayerSettings searchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
        return this;
    }

    @Valid
    @Schema(name="searchIndex", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="searchIndex")
    public SearchIndexRef getSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
    }

    public WMSLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public WMSLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WMSLayerSettings legendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
        return this;
    }

    @Schema(name="legendImageId", description="ID of uploaded legend image", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="legendImageId")
    public String getLegendImageId() {
        return this.legendImageId;
    }

    public void setLegendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
    }

    public WMSLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public WMSLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList();
        }
        this.authorizationRules.add(authorizationRulesItem);
        return this;
    }

    @Valid
    @Schema(name="authorizationRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="authorizationRules")
    public @Valid List<@Valid AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public WMSLayerSettings tilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
        return this;
    }

    @NotNull
    @Schema(name="tilingDisabled", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tilingDisabled")
    public Boolean getTilingDisabled() {
        return this.tilingDisabled;
    }

    public void setTilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
    }

    public WMSLayerSettings tilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
        return this;
    }

    @NotNull
    @Schema(name="tilingGutter", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tilingGutter")
    public Integer getTilingGutter() {
        return this.tilingGutter;
    }

    public void setTilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WMSLayerSettings wmSLayerSettings = (WMSLayerSettings)o;
        return Objects.equals(this.title, wmSLayerSettings.title) && Objects.equals(this.hiDpiDisabled, wmSLayerSettings.hiDpiDisabled) && Objects.equals(this.featureType, wmSLayerSettings.featureType) && Objects.equals(this.searchIndex, wmSLayerSettings.searchIndex) && Objects.equals(this.attribution, wmSLayerSettings.attribution) && Objects.equals(this.description, wmSLayerSettings.description) && Objects.equals(this.legendImageId, wmSLayerSettings.legendImageId) && Objects.equals(this.authorizationRules, wmSLayerSettings.authorizationRules) && Objects.equals(this.tilingDisabled, wmSLayerSettings.tilingDisabled) && Objects.equals(this.tilingGutter, wmSLayerSettings.tilingGutter);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hiDpiDisabled, this.featureType, this.searchIndex, this.attribution, this.description, this.legendImageId, this.authorizationRules, this.tilingDisabled, this.tilingGutter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WMSLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString((Object)this.hiDpiDisabled)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString((Object)this.featureType)).append("\n");
        sb.append("    searchIndex: ").append(this.toIndentedString((Object)this.searchIndex)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString((Object)this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    legendImageId: ").append(this.toIndentedString((Object)this.legendImageId)).append("\n");
        sb.append("    authorizationRules: ").append(this.toIndentedString((Object)this.authorizationRules)).append("\n");
        sb.append("    tilingDisabled: ").append(this.toIndentedString((Object)this.tilingDisabled)).append("\n");
        sb.append("    tilingGutter: ").append(this.toIndentedString((Object)this.tilingGutter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

