/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.util;

import jakarta.servlet.http.HttpServletRequest;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Set;
import org.springframework.http.HttpHeaders;

public class HttpProxyUtil {
    public static void addForwardedForRequestHeaders(HttpRequest.Builder requestBuilder, HttpServletRequest request) {
        try {
            Object ip = request.getRemoteAddr();
            InetAddress inetAddress = InetAddress.getByName((String)ip);
            if (inetAddress instanceof Inet6Address) {
                Inet6Address inet6Address = (Inet6Address)inetAddress;
                int scopeId = inet6Address.getScopeId();
                if (scopeId > 0) {
                    ip = inet6Address.getHostName().replaceAll("%" + scopeId + "$", "");
                }
                ip = "\"[" + (String)ip + "]\"";
            }
            requestBuilder.header("X-Forwarded-For", (String)ip);
            requestBuilder.header("Forwarded", "for=" + (String)ip);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static void passthroughRequestHeaders(HttpRequest.Builder requestBuilder, HttpServletRequest request, Set<String> headers) {
        for (String header : headers) {
            String value = request.getHeader(header);
            if (value == null) continue;
            requestBuilder.header(header, value);
        }
    }

    public static HttpHeaders passthroughResponseHeaders(java.net.http.HttpHeaders upstreamHeaders, Set<String> allowedResponseHeaders) {
        HttpHeaders headers = new HttpHeaders();
        for (String header : allowedResponseHeaders) {
            headers.addAll(header, upstreamHeaders.allValues(header));
        }
        return headers;
    }

    public static void setHttpBasicAuthenticationHeader(HttpRequest.Builder requestBuilder, String username, String password) {
        if (username != null && password != null) {
            String toEncode = username + ":" + password;
            String encoded = Base64.getEncoder().encodeToString(toEncode.getBytes(StandardCharsets.UTF_8));
            requestBuilder.header("Authorization", "Basic " + encoded);
        }
    }
}

