/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.Bounds;
import nl.b3p.tailormap.api.persistence.json.TileLayerHiDpiMode;

@Schema(name="AppLayer", description=" A map layer, but only enough information to draw the layer. For advanced functionality that required access to attributes the LayerDetails should be requested. ")
public class AppLayer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String serviceId;
    private String layerName;
    private String title;
    private String url;
    private Boolean visible;
    private Integer opacity;
    private Double minScale;
    private Double maxScale;
    private String legendImageUrl;
    private Boolean tilingDisabled;
    private Integer tilingGutter;
    private Boolean hiDpiDisabled;
    private TileLayerHiDpiMode hiDpiMode;
    private String hiDpiSubstituteLayer;
    private Integer minZoom;
    private Integer maxZoom;
    private Integer tileSize;
    private Bounds tileGridExtent;
    private Boolean hasAttributes;
    private Boolean editable;
    private String attribution;
    private String description;
    private Double autoRefreshInSeconds = null;

    public AppLayer id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Unique id of this layer reference in the application. Another app layer may exist which references the same layerName of the same service, but with different settings.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AppLayer serviceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @NotNull
    @Schema(name="serviceId", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="serviceId")
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public AppLayer layerName(String layerName) {
        this.layerName = layerName;
        return this;
    }

    @NotNull
    @Schema(name="layerName", description="Layer name as known by the service.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="layerName")
    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public AppLayer title(String title) {
        this.title = title;
        return this;
    }

    @NotNull
    @Schema(name="title", description="Layer title or display name.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AppLayer url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="url", description="URL for this specific layer. If empty use URL from the service.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AppLayer visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @NotNull
    @Schema(name="visible", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="visible")
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public AppLayer opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="opacity", description="The opacity of the layer (in percentage, from 0-100, where 0 is \"transparent\" and 100 is \"opaque\").", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="opacity")
    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public AppLayer minScale(Double minScale) {
        this.minScale = minScale;
        return this;
    }

    @Schema(name="minScale", description="Minimum scale at which this layer should be shown or is not blank. When absent there is no minimum. As reported by the service (ScaleHint or MinScaleDenominator).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minScale")
    public Double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Double minScale) {
        this.minScale = minScale;
    }

    public AppLayer maxScale(Double maxScale) {
        this.maxScale = maxScale;
        return this;
    }

    @Schema(name="maxScale", description="Maximum scale denominator at which this layer should be shown or is not blank. When absent there is no maximum. As reported by the service (ScaleHint or MaxScaleDenominator).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maxScale")
    public Double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Double maxScale) {
        this.maxScale = maxScale;
    }

    public AppLayer legendImageUrl(String legendImageUrl) {
        this.legendImageUrl = legendImageUrl;
        return this;
    }

    @Schema(name="legendImageUrl", description="URL to an image with the layer legend.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="legendImageUrl")
    public String getLegendImageUrl() {
        return this.legendImageUrl;
    }

    public void setLegendImageUrl(String legendImageUrl) {
        this.legendImageUrl = legendImageUrl;
    }

    public AppLayer tilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
        return this;
    }

    @Schema(name="tilingDisabled", description="Request a single tile for WMS (may result in errors when max size/mem exceeded)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tilingDisabled")
    public Boolean getTilingDisabled() {
        return this.tilingDisabled;
    }

    public void setTilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
    }

    public AppLayer tilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
        return this;
    }

    @Schema(name="tilingGutter", description="Gutter around tile to discard to avoid tile edge rendering artifacts", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tilingGutter")
    public Integer getTilingGutter() {
        return this.tilingGutter;
    }

    public void setTilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
    }

    public AppLayer hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", description="Whether the layer should not be rendered in high DPI when available", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public AppLayer hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
        return this;
    }

    @Valid
    @Schema(name="hiDpiMode", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiMode")
    public TileLayerHiDpiMode getHiDpiMode() {
        return this.hiDpiMode;
    }

    public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
    }

    public AppLayer hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
        return this;
    }

    @Schema(name="hiDpiSubstituteLayer", description="The layer name of this service to substitute when the device pixel ratio is higher", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiSubstituteLayer")
    public String getHiDpiSubstituteLayer() {
        return this.hiDpiSubstituteLayer;
    }

    public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    }

    public AppLayer minZoom(Integer minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    @Schema(name="minZoom", description="Minimum zoom for XYZ layer", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minZoom")
    public Integer getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(Integer minZoom) {
        this.minZoom = minZoom;
    }

    public AppLayer maxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    @Schema(name="maxZoom", description="Maximum zoom for XYZ layer", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maxZoom")
    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public AppLayer tileSize(Integer tileSize) {
        this.tileSize = tileSize;
        return this;
    }

    @Schema(name="tileSize", description="Tile size for XYZ layer", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tileSize")
    public Integer getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Integer tileSize) {
        this.tileSize = tileSize;
    }

    public AppLayer tileGridExtent(Bounds tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
        return this;
    }

    @Valid
    @Schema(name="tileGridExtent", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tileGridExtent")
    public Bounds getTileGridExtent() {
        return this.tileGridExtent;
    }

    public void setTileGridExtent(Bounds tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
    }

    public AppLayer hasAttributes(Boolean hasAttributes) {
        this.hasAttributes = hasAttributes;
        return this;
    }

    @NotNull
    @Schema(name="hasAttributes", description="Whether this layer has attributes that can be accessed eg. for feature info or attribute list", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="hasAttributes")
    public Boolean getHasAttributes() {
        return this.hasAttributes;
    }

    public void setHasAttributes(Boolean hasAttributes) {
        this.hasAttributes = hasAttributes;
    }

    public AppLayer editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    @Schema(name="editable", description="Whether this layer can be edited.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="editable")
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public AppLayer attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution text to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public AppLayer description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description text to show for this layer, may contain some links and images (see htmlify pipe)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AppLayer autoRefreshInSeconds(Double autoRefreshInSeconds) {
        this.autoRefreshInSeconds = autoRefreshInSeconds;
        return this;
    }

    @Schema(name="autoRefreshInSeconds", description="Automatically refresh the layer (in seconds)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="autoRefreshInSeconds")
    public Double getAutoRefreshInSeconds() {
        return this.autoRefreshInSeconds;
    }

    public void setAutoRefreshInSeconds(Double autoRefreshInSeconds) {
        this.autoRefreshInSeconds = autoRefreshInSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppLayer appLayer = (AppLayer)o;
        return Objects.equals(this.id, appLayer.id) && Objects.equals(this.serviceId, appLayer.serviceId) && Objects.equals(this.layerName, appLayer.layerName) && Objects.equals(this.title, appLayer.title) && Objects.equals(this.url, appLayer.url) && Objects.equals(this.visible, appLayer.visible) && Objects.equals(this.opacity, appLayer.opacity) && Objects.equals(this.minScale, appLayer.minScale) && Objects.equals(this.maxScale, appLayer.maxScale) && Objects.equals(this.legendImageUrl, appLayer.legendImageUrl) && Objects.equals(this.tilingDisabled, appLayer.tilingDisabled) && Objects.equals(this.tilingGutter, appLayer.tilingGutter) && Objects.equals(this.hiDpiDisabled, appLayer.hiDpiDisabled) && Objects.equals(this.hiDpiMode, appLayer.hiDpiMode) && Objects.equals(this.hiDpiSubstituteLayer, appLayer.hiDpiSubstituteLayer) && Objects.equals(this.minZoom, appLayer.minZoom) && Objects.equals(this.maxZoom, appLayer.maxZoom) && Objects.equals(this.tileSize, appLayer.tileSize) && Objects.equals(this.tileGridExtent, appLayer.tileGridExtent) && Objects.equals(this.hasAttributes, appLayer.hasAttributes) && Objects.equals(this.editable, appLayer.editable) && Objects.equals(this.attribution, appLayer.attribution) && Objects.equals(this.description, appLayer.description) && Objects.equals(this.autoRefreshInSeconds, appLayer.autoRefreshInSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.serviceId, this.layerName, this.title, this.url, this.visible, this.opacity, this.minScale, this.maxScale, this.legendImageUrl, this.tilingDisabled, this.tilingGutter, this.hiDpiDisabled, this.hiDpiMode, this.hiDpiSubstituteLayer, this.minZoom, this.maxZoom, this.tileSize, this.tileGridExtent, this.hasAttributes, this.editable, this.attribution, this.description, this.autoRefreshInSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppLayer {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString((Object)this.serviceId)).append("\n");
        sb.append("    layerName: ").append(this.toIndentedString((Object)this.layerName)).append("\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString((Object)this.url)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString((Object)this.visible)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString((Object)this.opacity)).append("\n");
        sb.append("    minScale: ").append(this.toIndentedString((Object)this.minScale)).append("\n");
        sb.append("    maxScale: ").append(this.toIndentedString((Object)this.maxScale)).append("\n");
        sb.append("    legendImageUrl: ").append(this.toIndentedString((Object)this.legendImageUrl)).append("\n");
        sb.append("    tilingDisabled: ").append(this.toIndentedString((Object)this.tilingDisabled)).append("\n");
        sb.append("    tilingGutter: ").append(this.toIndentedString((Object)this.tilingGutter)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString((Object)this.hiDpiDisabled)).append("\n");
        sb.append("    hiDpiMode: ").append(this.toIndentedString((Object)this.hiDpiMode)).append("\n");
        sb.append("    hiDpiSubstituteLayer: ").append(this.toIndentedString((Object)this.hiDpiSubstituteLayer)).append("\n");
        sb.append("    minZoom: ").append(this.toIndentedString((Object)this.minZoom)).append("\n");
        sb.append("    maxZoom: ").append(this.toIndentedString((Object)this.maxZoom)).append("\n");
        sb.append("    tileSize: ").append(this.toIndentedString((Object)this.tileSize)).append("\n");
        sb.append("    tileGridExtent: ").append(this.toIndentedString((Object)this.tileGridExtent)).append("\n");
        sb.append("    hasAttributes: ").append(this.toIndentedString((Object)this.hasAttributes)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString((Object)this.editable)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString((Object)this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    autoRefreshInSeconds: ").append(this.toIndentedString((Object)this.autoRefreshInSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

