package nl.b3p.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRule;
import nl.b3p.tailormap.api.persistence.json.FeatureTypeRef;
import nl.b3p.tailormap.api.persistence.json.SearchIndexRef;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Settings applying to a 3D Tileset layer.
 */

@Schema(name = "Tileset3DLayerSettings", description = "Settings applying to a 3D Tileset layer.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.6.0")
public class Tileset3DLayerSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title = null;

  private Boolean hiDpiDisabled = null;

  private FeatureTypeRef featureType;

  private SearchIndexRef searchIndex;

  private String attribution = null;

  private String description = null;

  private String legendImageId = null;

  @Valid
  private List<@Valid AuthorizationRule> authorizationRules = new ArrayList<>();

  public Tileset3DLayerSettings title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Override default title, null if not overridden.
   * @return title
  */
  
  @Schema(name = "title", description = "Override default title, null if not overridden.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Tileset3DLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
    return this;
  }

  /**
   * Get hiDpiDisabled
   * @return hiDpiDisabled
  */
  
  @Schema(name = "hiDpiDisabled", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiDisabled")
  public Boolean getHiDpiDisabled() {
    return hiDpiDisabled;
  }

  public void setHiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
  }

  public Tileset3DLayerSettings featureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
    return this;
  }

  /**
   * Get featureType
   * @return featureType
  */
  @Valid 
  @Schema(name = "featureType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("featureType")
  public FeatureTypeRef getFeatureType() {
    return featureType;
  }

  public void setFeatureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
  }

  public Tileset3DLayerSettings searchIndex(SearchIndexRef searchIndex) {
    this.searchIndex = searchIndex;
    return this;
  }

  /**
   * Get searchIndex
   * @return searchIndex
  */
  @Valid 
  @Schema(name = "searchIndex", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("searchIndex")
  public SearchIndexRef getSearchIndex() {
    return searchIndex;
  }

  public void setSearchIndex(SearchIndexRef searchIndex) {
    this.searchIndex = searchIndex;
  }

  public Tileset3DLayerSettings attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Attribution to show for this layer.
   * @return attribution
  */
  
  @Schema(name = "attribution", description = "Attribution to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public Tileset3DLayerSettings description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description to show for this layer.
   * @return description
  */
  
  @Schema(name = "description", description = "Description to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Tileset3DLayerSettings legendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
    return this;
  }

  /**
   * ID of uploaded legend image
   * @return legendImageId
  */
  
  @Schema(name = "legendImageId", description = "ID of uploaded legend image", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("legendImageId")
  public String getLegendImageId() {
    return legendImageId;
  }

  public void setLegendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
  }

  public Tileset3DLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
    return this;
  }

  public Tileset3DLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
    if (this.authorizationRules == null) {
      this.authorizationRules = new ArrayList<>();
    }
    this.authorizationRules.add(authorizationRulesItem);
    return this;
  }

  /**
   * Get authorizationRules
   * @return authorizationRules
  */
  @Valid 
  @Schema(name = "authorizationRules", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("authorizationRules")
  public List<@Valid AuthorizationRule> getAuthorizationRules() {
    return authorizationRules;
  }

  public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Tileset3DLayerSettings tileset3DLayerSettings = (Tileset3DLayerSettings) o;
    return Objects.equals(this.title, tileset3DLayerSettings.title) &&
        Objects.equals(this.hiDpiDisabled, tileset3DLayerSettings.hiDpiDisabled) &&
        Objects.equals(this.featureType, tileset3DLayerSettings.featureType) &&
        Objects.equals(this.searchIndex, tileset3DLayerSettings.searchIndex) &&
        Objects.equals(this.attribution, tileset3DLayerSettings.attribution) &&
        Objects.equals(this.description, tileset3DLayerSettings.description) &&
        Objects.equals(this.legendImageId, tileset3DLayerSettings.legendImageId) &&
        Objects.equals(this.authorizationRules, tileset3DLayerSettings.authorizationRules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, hiDpiDisabled, featureType, searchIndex, attribution, description, legendImageId, authorizationRules);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Tileset3DLayerSettings {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    hiDpiDisabled: ").append(toIndentedString(hiDpiDisabled)).append("\n");
    sb.append("    featureType: ").append(toIndentedString(featureType)).append("\n");
    sb.append("    searchIndex: ").append(toIndentedString(searchIndex)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    legendImageId: ").append(toIndentedString(legendImageId)).append("\n");
    sb.append("    authorizationRules: ").append(toIndentedString(authorizationRules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

