/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.configuration;

import jakarta.annotation.PostConstruct;
import java.util.List;
import nl.b3p.tailormap.api.configuration.ddl.FlywayMigrationResult;
import nl.b3p.tailormap.api.persistence.Catalog;
import nl.b3p.tailormap.api.persistence.json.CatalogNode;
import nl.b3p.tailormap.api.repository.CatalogRepository;
import nl.b3p.tailormap.api.security.InternalAdminAuthentication;
import org.flywaydb.core.api.output.MigrateResult;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TailormapDatabaseMigration {
    private final CatalogRepository catalogRepository;
    private final FlywayMigrationResult migrationResult;

    public TailormapDatabaseMigration(CatalogRepository catalogRepository, FlywayMigrationResult migrationResult) {
        this.catalogRepository = catalogRepository;
        this.migrationResult = migrationResult;
    }

    @PostConstruct
    public void databaseMigration() {
        MigrateResult migrateResult = this.migrationResult.getMigrateResult();
        if (migrateResult == null || migrateResult.migrationsExecuted == 0) {
            return;
        }
        InternalAdminAuthentication.setInSecurityContext();
        try {
            if (migrateResult.migrations.stream().anyMatch(m -> "1".equals(m.version))) {
                this.createRootCatalog();
            }
        }
        finally {
            InternalAdminAuthentication.clearSecurityContextAuthentication();
        }
    }

    private void createRootCatalog() {
        Catalog catalog = new Catalog().setId("main").setNodes(List.of(new CatalogNode().root(true).title("root").id("root")));
        this.catalogRepository.save(catalog);
    }
}

