/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.persistence.Configuration;
import nl.b3p.tailormap.api.repository.ConfigurationRepository;
import nl.b3p.tailormap.api.viewer.model.ConfigResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
public class ConfigurationController {
    private final ConfigurationRepository configurationRepository;

    public ConfigurationController(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    @GetMapping(path={"${tailormap-api.base-path}/config/{key}"}, produces={"application/json"})
    @Timed(value="get_config_key", description="Get configuration value")
    @Counted(value="get_config_key", description="Count of get configuration value")
    public ResponseEntity<Serializable> getConfig(@PathVariable String key) {
        Configuration config = this.configurationRepository.getAvailableForViewer(key).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        ConfigResponse response = new ConfigResponse();
        response.setKey(key);
        response.setValue(config.getValue());
        response.setObject(config.getJsonValue());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)response);
    }
}

